/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Deprecated(forRemoval=true)
public class ExecUtil {
    private static final Logger LOG = Logger.getLogger(ExecUtil.class);
    public static final Function<InputStream, Runnable> INFO_LOGGING = i -> new HandleOutput((InputStream)i, Logger.Level.INFO);
    public static final Function<InputStream, Runnable> DEBUG_LOGGING = i -> new HandleOutput((InputStream)i, Logger.Level.DEBUG);
    public static final Function<InputStream, Runnable> SYSTEM_LOGGING = HandleOutput::new;
    private static final Function<InputStream, Runnable> DEFAULT_LOGGING = INFO_LOGGING;
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public static boolean exec(String command, String ... args) {
        return ExecUtil.exec(new File("."), command, args);
    }

    public static boolean execWithTimeout(Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(new File("."), timeout, command, args);
    }

    public static boolean exec(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, DEFAULT_LOGGING, command, args);
    }

    public static boolean execWithTimeout(File directory, Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(directory, DEFAULT_LOGGING, timeout, command, args);
    }

    public static boolean exec(File directory, Function<InputStream, Runnable> outputFilterFunction, String command, String ... args) {
        return ExecUtil.execProcess(ExecUtil.startProcess(directory, command, args), outputFilterFunction) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execProcess(Process process, Function<InputStream, Runnable> outputFilterFunction) {
        try {
            Function<InputStream, Runnable> loggingFunction = outputFilterFunction != null ? outputFilterFunction : DEFAULT_LOGGING;
            Thread t = new Thread(loggingFunction.apply(process.getInputStream()));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor();
            int n = process.exitValue();
            return n;
        }
        catch (InterruptedException e) {
            int n = -1;
            return n;
        }
        finally {
            ExecUtil.destroyProcess(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execProcessWithTimeout(Process process, Function<InputStream, Runnable> outputFilterFunction, Duration timeout) {
        try {
            Function<InputStream, Runnable> loggingFunction = outputFilterFunction != null ? outputFilterFunction : DEFAULT_LOGGING;
            Thread t = new Thread(loggingFunction.apply(process.getInputStream()));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            int n = process.exitValue();
            return n;
        }
        catch (InterruptedException e) {
            int n = -1;
            return n;
        }
        finally {
            ExecUtil.destroyProcess(process);
        }
    }

    public static boolean execWithTimeout(File directory, Function<InputStream, Runnable> outputFilterFunction, Duration timeout, String command, String ... args) {
        return ExecUtil.execProcessWithTimeout(ExecUtil.startProcess(directory, command, args), outputFilterFunction, timeout) == 0;
    }

    public static boolean execWithDebugLogging(String command, String ... args) {
        return ExecUtil.execWithDebugLogging(new File("."), command, args);
    }

    public static boolean execWithDebugLogging(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, DEBUG_LOGGING, command, args);
    }

    public static boolean execWithSystemLogging(String command, String ... args) {
        return ExecUtil.execWithSystemLogging(new File("."), command, args);
    }

    public static boolean execWithSystemLogging(File directory, String command, String ... args) {
        return ExecUtil.exec(directory, SYSTEM_LOGGING, command, args);
    }

    public static Process startProcess(File directory, Map<String, String> environment, String command, String ... args) {
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true);
            if (environment != null && !environment.isEmpty()) {
                Map<String, String> env = processBuilder.environment();
                environment.forEach((key, value) -> {
                    if (value == null) {
                        env.remove(key);
                    } else {
                        env.put((String)key, (String)value);
                    }
                });
            }
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
    }

    public static Process startProcess(File directory, String command, String ... args) {
        return ExecUtil.startProcess(directory, Collections.emptyMap(), command, args);
    }

    public static void destroyProcess(Process process) {
        process.destroy();
        int i = 0;
        while (process.isAlive() && i++ < 10) {
            try {
                process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    public static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Optional<Logger.Level> logLevel;
        private final Logger logger;

        public HandleOutput(InputStream is) {
            this(is, null);
        }

        public HandleOutput(InputStream is, Logger.Level logLevel) {
            this(is, logLevel, LOG);
        }

        public HandleOutput(InputStream is, Logger.Level logLevel, Logger logger) {
            this.is = is;
            this.logLevel = Optional.ofNullable(logLevel);
            this.logger = logger;
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    String l = line;
                    this.logLevel.ifPresentOrElse(level -> this.logger.log(level, (Object)l), () -> System.out.println(l));
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                this.logLevel.ifPresentOrElse(level -> this.logger.log(level, (Object)"Failed to handle output", (Throwable)e), () -> e.printStackTrace());
            }
        }
    }
}

