/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;

public class KeycloakPropertiesConfigSource
extends AbstractLocationConfigSourceLoader {
    public static final int PROPERTIES_FILE_ORDINAL = 475;
    private static final String KEYCLOAK_CONFIG_FILE_ENV = "KC_CONFIG_FILE";
    private static final String KEYCLOAK_CONF_FILE = "keycloak.conf";
    public static final String KEYCLOAK_CONFIG_FILE_PROP = "kc.config.file";

    protected String[] getFileExtensions() {
        return new String[]{"conf"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(KeycloakPropertiesConfigSource.transform(ConfigSourceUtil.urlToMap((URL)url)), url.toString(), ordinal);
    }

    private static Map<String, String> transform(Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        properties.entrySet().forEach(entry -> result.put("kc." + (String)entry.getKey(), (String)entry.getValue()));
        return result;
    }

    public static class InFileSystem
    extends KeycloakPropertiesConfigSource
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            Path configFile = this.getConfigurationFile();
            if (configFile == null) {
                return Collections.emptyList();
            }
            return this.getConfigSources(classLoader, configFile);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader, Path configFile) {
            return this.loadConfigSources(configFile.toUri().toString(), 475, classLoader);
        }

        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            return Collections.emptyList();
        }

        public Path getConfigurationFile() {
            File file;
            String homeDir;
            String filePath = System.getProperty(KeycloakPropertiesConfigSource.KEYCLOAK_CONFIG_FILE_PROP);
            if (filePath == null) {
                filePath = System.getenv(KeycloakPropertiesConfigSource.KEYCLOAK_CONFIG_FILE_ENV);
            }
            if (filePath == null && (homeDir = Environment.getHomeDir()) != null && (file = Paths.get(homeDir, "conf", KeycloakPropertiesConfigSource.KEYCLOAK_CONF_FILE).toFile()).exists()) {
                filePath = file.getAbsolutePath();
            }
            if (filePath == null) {
                return null;
            }
            return Paths.get(filePath, new String[0]);
        }
    }
}

