/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.storage.spi;

import io.smallrye.context.storage.impl.DefaultStorageManagerProvider;
import io.smallrye.context.storage.spi.StorageManager;
import io.smallrye.context.storage.spi.StorageManagerProviderRegistration;
import java.security.AccessController;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public interface StorageManagerProvider {
    public static final AtomicReference<StorageManagerProvider> INSTANCE = new AtomicReference();

    public static StorageManagerProvider instance() {
        StorageManagerProvider provider = INSTANCE.get();
        if (provider == null) {
            for (StorageManagerProvider serviceProvider : ServiceLoader.load(StorageManagerProvider.class)) {
                if (INSTANCE.compareAndSet(null, serviceProvider)) {
                    provider = serviceProvider;
                    continue;
                }
                throw new IllegalStateException("StorageManagerProvider already set");
            }
            if (provider == null) {
                provider = new DefaultStorageManagerProvider();
            }
        }
        return provider;
    }

    public static StorageManagerProviderRegistration register(StorageManagerProvider provider) throws IllegalStateException {
        if (INSTANCE.compareAndSet(null, provider)) {
            return new StorageManagerProviderRegistration(provider);
        }
        throw new IllegalStateException("A StorageManagerProvider implementation has already been registered.");
    }

    default public StorageManager getStorageManager() {
        ClassLoader loader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        return this.getStorageManager(loader);
    }

    public StorageManager getStorageManager(ClassLoader var1);
}

