/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

public class SortedSetAddArgs {
    public static final String ADD_AND_UPDATE_ONLY_INCOMPATIBLE_ERROR = "addOnly and updateOnly can't both be true";
    public static final String ADD_AND_UPDATE_OPTIONS_INCOMPATIBLE_ERROR = "addOnly, updateGreaterScoresOnly and updateLessScoresOnly can't all be true";
    public boolean addOnly;
    public boolean updateOnly;
    public boolean updateLessScoresOnly;
    public boolean updateGreaterScoresOnly;
    public boolean returnChangedCount;
    public boolean replace;
    public boolean incr;

    private SortedSetAddArgs(Builder builder) {
        this.addOnly = builder.addOnly;
        this.updateOnly = builder.updateOnly;
        this.updateLessScoresOnly = builder.updateLessScoresOnly;
        this.updateGreaterScoresOnly = builder.updateGreaterScoresOnly;
        this.returnChangedCount = builder.returnChangedCount;
        this.replace = builder.replace;
        this.incr = builder.incr;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private boolean addOnly;
        private boolean updateOnly;
        private boolean updateLessScoresOnly;
        private boolean updateGreaterScoresOnly;
        private boolean returnChangedCount;
        private boolean replace;
        private boolean incr;

        private Builder() {
        }

        public Builder addOnly() {
            this.addOnly = true;
            return this;
        }

        public Builder updateOnly() {
            this.updateOnly = true;
            return this;
        }

        public Builder updateLessScoresOnly() {
            this.updateLessScoresOnly = true;
            return this;
        }

        public Builder updateGreaterScoresOnly() {
            this.updateGreaterScoresOnly = true;
            return this;
        }

        public Builder returnChangedCount() {
            this.returnChangedCount = true;
            return this;
        }

        public Builder replace() {
            this.replace = true;
            return this;
        }

        public Builder incr() {
            this.incr = true;
            return this;
        }

        public SortedSetAddArgs build() {
            if (this.updateOnly && this.addOnly) {
                throw new IllegalArgumentException(SortedSetAddArgs.ADD_AND_UPDATE_ONLY_INCOMPATIBLE_ERROR);
            }
            if (this.addOnly && this.updateGreaterScoresOnly || this.addOnly && this.updateLessScoresOnly || this.updateGreaterScoresOnly && this.updateLessScoresOnly) {
                throw new IllegalArgumentException(SortedSetAddArgs.ADD_AND_UPDATE_OPTIONS_INCOMPATIBLE_ERROR);
            }
            return new SortedSetAddArgs(this);
        }
    }
}

