/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.GraphSemantic;

public interface MultiIdentifierLoadAccess<T> {
    default public MultiIdentifierLoadAccess<T> with(LockMode lockMode) {
        return this.with(lockMode, PessimisticLockScope.NORMAL);
    }

    public MultiIdentifierLoadAccess<T> with(LockMode var1, PessimisticLockScope var2);

    public MultiIdentifierLoadAccess<T> with(Timeout var1);

    @Deprecated(since="7.0", forRemoval=true)
    public MultiIdentifierLoadAccess<T> with(LockOptions var1);

    public MultiIdentifierLoadAccess<T> with(CacheMode var1);

    public MultiIdentifierLoadAccess<T> withReadOnly(boolean var1);

    default public MultiIdentifierLoadAccess<T> withFetchGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.FETCH);
    }

    default public MultiIdentifierLoadAccess<T> withLoadGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.LOAD);
    }

    @Deprecated(since="6.3")
    default public MultiIdentifierLoadAccess<T> with(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.LOAD);
    }

    public MultiIdentifierLoadAccess<T> with(EntityGraph<T> var1, GraphSemantic var2);

    public MultiIdentifierLoadAccess<T> enableFetchProfile(String var1);

    public MultiIdentifierLoadAccess<T> disableFetchProfile(String var1);

    public MultiIdentifierLoadAccess<T> withBatchSize(int var1);

    public MultiIdentifierLoadAccess<T> enableSessionCheck(boolean var1);

    public MultiIdentifierLoadAccess<T> enableReturnOfDeletedEntities(boolean var1);

    public MultiIdentifierLoadAccess<T> enableOrderedReturn(boolean var1);

    public <K> List<T> multiLoad(K ... var1);

    public <K> List<T> multiLoad(List<K> var1);
}

