/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import jakarta.persistence.GenerationType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.AnnotationException;
import org.hibernate.Internal;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.internal.GeneratorStrategies;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.SequenceGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableGeneratorJpaAnnotation;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.TypeDetails;

public class IdentifierGeneratorDefinition
implements Serializable {
    private final String name;
    private final String strategy;
    private final Map<String, String> parameters;

    public IdentifierGeneratorDefinition(String name, String strategy, Map<String, String> parameters) {
        this.name = name;
        this.strategy = strategy;
        this.parameters = CollectionHelper.isEmpty(parameters) ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
    }

    public IdentifierGeneratorDefinition(String name, Map<String, String> parameters) {
        this(name, name, parameters);
    }

    public IdentifierGeneratorDefinition(String name) {
        this(name, name);
    }

    public IdentifierGeneratorDefinition(String name, String strategy) {
        this.name = name;
        this.strategy = strategy;
        this.parameters = Collections.emptyMap();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Internal
    public static IdentifierGeneratorDefinition createImplicit(String name, TypeDetails idType, String generatorName, GenerationType generationType) {
        return switch (generationType == null ? GenerationType.SEQUENCE : generationType) {
            default -> throw new IncompatibleClassChangeError();
            case GenerationType.SEQUENCE -> IdentifierGeneratorDefinition.buildSequenceGeneratorDefinition(name);
            case GenerationType.TABLE -> IdentifierGeneratorDefinition.buildTableGeneratorDefinition(name);
            case GenerationType.AUTO -> new IdentifierGeneratorDefinition(name, GeneratorStrategies.generatorStrategy(generationType, generatorName, idType), Collections.singletonMap("GENERATOR_NAME", name));
            case GenerationType.IDENTITY, GenerationType.UUID -> throw new AnnotationException("@GeneratedValue annotation specified 'strategy=" + String.valueOf(generationType) + "' and 'generator' but the generator name is unnecessary");
        };
    }

    private static IdentifierGeneratorDefinition buildTableGeneratorDefinition(String name) {
        TableGeneratorJpaAnnotation tableGeneratorUsage = (TableGeneratorJpaAnnotation)JpaAnnotations.TABLE_GENERATOR.createUsage(null);
        if (StringHelper.isNotEmpty(name)) {
            tableGeneratorUsage.name(name);
        }
        Builder builder = new Builder();
        GeneratorParameters.interpretTableGenerator(tableGeneratorUsage, builder);
        return builder.build();
    }

    private static IdentifierGeneratorDefinition buildSequenceGeneratorDefinition(String name) {
        SequenceGeneratorJpaAnnotation sequenceGeneratorUsage = (SequenceGeneratorJpaAnnotation)((Object)JpaAnnotations.SEQUENCE_GENERATOR.createUsage(null));
        if (StringHelper.isNotEmpty(name)) {
            sequenceGeneratorUsage.name(name);
        }
        Builder builder = new Builder();
        GeneratorParameters.interpretSequenceGenerator(sequenceGeneratorUsage, builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifierGeneratorDefinition)) {
            return false;
        }
        IdentifierGeneratorDefinition that = (IdentifierGeneratorDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.strategy, that.strategy) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.strategy, this.parameters);
    }

    public String toString() {
        return "IdentifierGeneratorDefinition{name='" + this.name + "', strategy='" + this.strategy + "', parameters=" + String.valueOf(this.parameters) + "}";
    }

    public static class Builder {
        private String name;
        private String strategy;
        private Map<String, String> parameters;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public void addParam(String name, String value) {
            this.parameters().put(name, value);
        }

        private Map<String, String> parameters() {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, String>();
            }
            return this.parameters;
        }

        public void addParams(Map<String, String> parameters) {
            this.parameters().putAll(parameters);
        }

        public IdentifierGeneratorDefinition build() {
            return new IdentifierGeneratorDefinition(this.name, this.strategy, this.parameters);
        }
    }
}

