/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.spi;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.hibernate.boot.model.convert.internal.ConverterDescriptors;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.spi.ClassmateContext;
import org.hibernate.boot.spi.MetadataBuildingContext;

public record RegisteredConversion(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, ConverterDescriptor<?, ?> converterDescriptor) {
    public RegisteredConversion {
        assert (converterType != null);
    }

    public RegisteredConversion(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, MetadataBuildingContext context) {
        this(explicitDomainType, converterType, autoApply, RegisteredConversion.determineConverterDescriptor(explicitDomainType, converterType, autoApply, context));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisteredConversion)) {
            return false;
        }
        RegisteredConversion that = (RegisteredConversion)o;
        return this.autoApply == that.autoApply && Objects.equals(this.explicitDomainType, that.explicitDomainType) && Objects.equals(this.converterType, that.converterType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.explicitDomainType, this.converterType);
    }

    private static ConverterDescriptor<?, ?> determineConverterDescriptor(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, MetadataBuildingContext context) {
        ClassmateContext classmateContext = context.getBootstrapContext().getClassmateContext();
        List<ResolvedType> resolvedParamTypes = ConverterHelper.resolveConverterClassParamTypes(converterType, classmateContext);
        ResolvedType relationalType = resolvedParamTypes.get(1);
        ResolvedType domainTypeToMatch = Void.TYPE.equals(explicitDomainType) ? resolvedParamTypes.get(0) : classmateContext.getTypeResolver().resolve(explicitDomainType, new Type[0]);
        return ConverterDescriptors.of(converterType, domainTypeToMatch, relationalType, autoApply);
    }

    public Class<?> getExplicitDomainType() {
        return this.explicitDomainType;
    }

    public Class<? extends AttributeConverter<?, ?>> getConverterType() {
        return this.converterType;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public ConverterDescriptor<?, ?> getConverterDescriptor() {
        return this.converterDescriptor;
    }
}

