/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.selector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.boot.registry.selector.internal.DefaultDialectSelector;
import org.hibernate.boot.registry.selector.spi.DialectSelector;
import org.hibernate.dialect.Dialect;

public class AggregatedDialectSelector
implements DialectSelector {
    private final List<DialectSelector> dialectSelectors;

    public AggregatedDialectSelector(Iterable<DialectSelector> dialectSelectorProvider) {
        ArrayList<DialectSelector> dialectSelectors = new ArrayList<DialectSelector>();
        for (DialectSelector dialectSelector : dialectSelectorProvider) {
            dialectSelectors.add(dialectSelector);
        }
        dialectSelectors.add(new DefaultDialectSelector());
        this.dialectSelectors = dialectSelectors;
    }

    @Override
    public Class<? extends Dialect> resolve(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            return null;
        }
        for (DialectSelector dialectSelector : this.dialectSelectors) {
            Class dialectClass = dialectSelector.resolve(name);
            if (dialectClass == null) continue;
            return dialectClass;
        }
        return null;
    }
}

