/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;

final class EnhancerCacheProvider
extends TypePool.CacheProvider.Simple {
    private final ThreadLocal<EnhancementState> enhancementState = new ThreadLocal();

    EnhancerCacheProvider() {
    }

    public TypePool.Resolution find(String name) {
        EnhancementState enhancementState = this.getEnhancementState();
        if (enhancementState != null && enhancementState.getClassName().equals(name)) {
            return enhancementState.getTypePoolResolution();
        }
        return super.find(name);
    }

    EnhancementState getEnhancementState() {
        return this.enhancementState.get();
    }

    void setEnhancementState(EnhancementState state) {
        this.enhancementState.set(state);
    }

    void removeEnhancementState() {
        this.enhancementState.remove();
    }

    static final class EnhancementState {
        private final String className;
        private final ClassFileLocator.Resolution classFileResolution;
        private TypePool.Resolution typePoolResolution;

        public EnhancementState(String className, ClassFileLocator.Resolution classFileResolution) {
            this.className = className;
            this.classFileResolution = classFileResolution;
        }

        public String getClassName() {
            return this.className;
        }

        public ClassFileLocator.Resolution getClassFileResolution() {
            return this.classFileResolution;
        }

        public TypePool.Resolution getTypePoolResolution() {
            return this.typePoolResolution;
        }

        public void setTypePoolResolution(TypePool.Resolution typePoolResolution) {
            this.typePoolResolution = typePoolResolution;
        }
    }
}

