/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public final class Collections {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(Collections.class);

    public static void processUnreachableCollection(PersistentCollection<?> coll, SessionImplementor session) {
        if (coll.getOwner() == null) {
            Collections.processNeverReferencedCollection(coll, session);
        } else {
            Collections.processDereferencedCollection(coll, session);
        }
    }

    private static void processDereferencedCollection(PersistentCollection<?> coll, SessionImplementor session) {
        boolean hasOrphanDelete;
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        CollectionPersister loadedPersister = entry.getLoadedPersister();
        if (loadedPersister != null && LOG.isTraceEnabled()) {
            LOG.trace("Collection dereferenced: " + MessageHelper.collectionInfoString(loadedPersister, coll, entry.getLoadedKey(), session));
        }
        boolean bl = hasOrphanDelete = loadedPersister != null && loadedPersister.hasOrphanDelete();
        if (hasOrphanDelete) {
            Object ownerId = Collections.getOwnerId(coll, session, loadedPersister);
            EntityKey key = session.generateEntityKey(ownerId, loadedPersister.getOwnerEntityPersister());
            Object owner = persistenceContext.getEntity(key);
            if (owner == null) {
                throw new AssertionFailure("collection owner not associated with session: " + loadedPersister.getRole());
            }
            EntityEntry e = persistenceContext.getEntry(owner);
            if (e != null && !e.getStatus().isDeletedOrGone()) {
                throw new HibernateException("A collection with orphan deletion was no longer referenced by the owning entity instance: " + loadedPersister.getRole());
            }
        }
        entry.setCurrentPersister(null);
        entry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(coll, entry, (SessionFactoryImplementor)session.getFactory());
    }

    private static Object getOwnerId(PersistentCollection<?> coll, SessionImplementor session, CollectionPersister loadedPersister) {
        Object ownerId = loadedPersister.getOwnerEntityPersister().getIdentifier(coll.getOwner(), session);
        if (ownerId == null) {
            EntityEntry ownerEntry;
            if (session.getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled() && (ownerEntry = session.getPersistenceContextInternal().getEntry(coll.getOwner())) != null) {
                ownerId = ownerEntry.getId();
            }
            if (ownerId == null) {
                throw new AssertionFailure("Unable to determine collection owner identifier for orphan delete processing");
            }
        }
        return ownerId;
    }

    private static void processNeverReferencedCollection(PersistentCollection<?> coll, SessionImplementor session) throws HibernateException {
        CollectionEntry entry = session.getPersistenceContextInternal().getCollectionEntry(coll);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found collection with unloaded owner: " + MessageHelper.collectionInfoString(entry.getLoadedPersister(), coll, entry.getLoadedKey(), session));
        }
        entry.setCurrentPersister(entry.getLoadedPersister());
        entry.setCurrentKey(entry.getLoadedKey());
        Collections.prepareCollectionForUpdate(coll, entry, (SessionFactoryImplementor)session.getFactory());
    }

    public static void processReachableCollection(PersistentCollection<?> collection, CollectionType type, Object entity, SessionImplementor session) {
        collection.setOwner(entity);
        CollectionEntry ce = session.getPersistenceContextInternal().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("Found two representations of same collection: " + type.getRole());
        }
        SessionFactory factory = session.getFactory();
        CollectionPersister persister = factory.getMappingMetamodel().getCollectionDescriptor(type.getRole());
        ce.setCurrentPersister(persister);
        ce.setCurrentKey(type.getKeyOfOwner(entity, session));
        boolean isBytecodeEnhanced = persister.getOwnerEntityPersister().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        if (isBytecodeEnhanced && !collection.wasInitialized()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping uninitialized bytecode-lazy collection: " + MessageHelper.collectionInfoString(persister, collection, ce.getCurrentKey(), session));
            }
            ce.setReached(true);
            ce.setProcessed(true);
            return;
        }
        if (ce.isReached()) {
            throw new HibernateException("Found shared references to a collection: " + type.getRole());
        }
        ce.setReached(true);
        if (LOG.isTraceEnabled()) {
            if (collection.wasInitialized()) {
                LOG.tracef("Collection found: %s, was: %s (initialized)", MessageHelper.collectionInfoString(persister, collection, ce.getCurrentKey(), session), MessageHelper.collectionInfoString(ce.getLoadedPersister(), collection, ce.getLoadedKey(), session));
            } else {
                LOG.tracef("Collection found: %s, was: %s (uninitialized)", MessageHelper.collectionInfoString(persister, collection, ce.getCurrentKey(), session), MessageHelper.collectionInfoString(ce.getLoadedPersister(), collection, ce.getLoadedKey(), session));
            }
        }
        Collections.prepareCollectionForUpdate(collection, ce, (SessionFactoryImplementor)factory);
    }

    private static void prepareCollectionForUpdate(PersistentCollection<?> collection, CollectionEntry entry, SessionFactoryImplementor factory) {
        if (entry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        entry.setProcessed(true);
        CollectionPersister loadedPersister = entry.getLoadedPersister();
        CollectionPersister currentPersister = entry.getCurrentPersister();
        if (loadedPersister != null || currentPersister != null) {
            boolean ownerChanged;
            boolean bl = ownerChanged = loadedPersister != currentPersister || Collections.wasKeyChanged(entry, factory, currentPersister);
            if (ownerChanged) {
                boolean orphanDeleteAndRoleChanged;
                boolean bl2 = orphanDeleteAndRoleChanged = loadedPersister != null && currentPersister != null && loadedPersister.hasOrphanDelete();
                if (orphanDeleteAndRoleChanged) {
                    throw new HibernateException("Don't change the reference to a collection with delete orphan enabled: " + loadedPersister.getRole());
                }
                if (currentPersister != null) {
                    entry.setDorecreate(true);
                }
                if (loadedPersister != null) {
                    entry.setDoremove(true);
                    if (entry.isDorecreate()) {
                        LOG.trace("Forcing collection initialization");
                        collection.forceInitialization();
                    }
                }
            } else if (collection.isDirty()) {
                entry.setDoupdate(true);
            }
        }
    }

    private static boolean wasKeyChanged(CollectionEntry entry, SessionFactoryImplementor factory, CollectionPersister currentPersister) {
        return currentPersister != null && !currentPersister.getKeyType().isEqual(entry.getLoadedKey(), entry.getCurrentKey(), factory) && !(entry.getLoadedKey() instanceof DelayedPostInsertIdentifier);
    }

    public static boolean skipRemoval(EventSource session, CollectionPersister persister, Object key) {
        if (persister != null && !persister.isOneToMany() && persister.isCascadeDeleteEnabled()) {
            EntityKey entityKey = session.generateEntityKey(key, persister.getOwnerEntityPersister());
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            EntityEntry entry = persistenceContext.getEntry(persistenceContext.getEntity(entityKey));
            return entry == null || entry.getStatus().isDeletedOrGone();
        }
        return false;
    }

    private Collections() {
    }
}

