/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.spi.ManagedBean;

public class FilterDefinition
implements Serializable {
    private final String filterName;
    private final String defaultFilterCondition;
    private final Map<String, JdbcMapping> explicitParamJaMappings = new HashMap<String, JdbcMapping>();
    private final Map<String, ManagedBean<? extends Supplier<?>>> parameterResolverMap = new HashMap();
    private final boolean autoEnabled;
    private final boolean applyToLoadByKey;

    public FilterDefinition(String name, String defaultCondition, @Nullable Map<String, JdbcMapping> explicitParamJaMappings) {
        this(name, defaultCondition, false, false, explicitParamJaMappings, Collections.emptyMap());
    }

    public FilterDefinition(String name, String defaultCondition, boolean autoEnabled, boolean applyToLoadByKey, @Nullable Map<String, JdbcMapping> explicitParamJaMappings, @Nullable Map<String, ManagedBean<? extends Supplier<?>>> parameterResolverMap) {
        this.filterName = name;
        this.defaultFilterCondition = defaultCondition;
        if (explicitParamJaMappings != null) {
            this.explicitParamJaMappings.putAll(explicitParamJaMappings);
        }
        if (parameterResolverMap != null) {
            this.parameterResolverMap.putAll(parameterResolverMap);
        }
        this.autoEnabled = autoEnabled;
        this.applyToLoadByKey = applyToLoadByKey;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public Set<String> getParameterNames() {
        Set<String> keys = this.explicitParamJaMappings.keySet();
        return keys;
    }

    public @Nullable JdbcMapping getParameterJdbcMapping(String parameterName) {
        return this.explicitParamJaMappings.get(parameterName);
    }

    public @Nullable Supplier<?> getParameterResolver(String parameterName) {
        ManagedBean<Supplier<?>> resolver = this.parameterResolverMap.get(parameterName);
        return resolver == null ? null : resolver.getBeanInstance();
    }

    public String getDefaultFilterCondition() {
        return this.defaultFilterCondition;
    }

    public boolean isAppliedToLoadByKey() {
        return this.applyToLoadByKey;
    }

    public Object processArgument(Object value) {
        return value;
    }

    public boolean isAutoEnabled() {
        return this.autoEnabled;
    }
}

