/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.internal.CacheLoadHelper;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractMultiIdEntityLoader<T>
implements MultiIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    protected final EntityIdentifierMapping identifierMapping;

    public AbstractMultiIdEntityLoader(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        this.identifierMapping = this.getLoadable().getIdentifierMapping();
    }

    protected EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityIdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return this.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
    }

    protected JdbcSelectExecutor getJdbcSelectExecutor() {
        return this.getJdbcServices().getJdbcSelectExecutor();
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.getEntityDescriptor();
    }

    @Override
    public final <K> List<T> load(K[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        assert (ids != null);
        return loadOptions.isOrderReturnEnabled() ? this.performOrderedMultiLoad(ids, loadOptions, session) : this.performUnorderedMultiLoad(ids, loadOptions, session);
    }

    private List<T> performUnorderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        assert (!loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Unordered batch load starting: " + this.getLoadable().getEntityName(), new Object[0]);
        }
        return this.unorderedMultiLoad(ids, loadOptions, session);
    }

    private List<T> performOrderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        assert (loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isTraceEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.tracef("Ordered batch load starting: " + this.getLoadable().getEntityName(), new Object[0]);
        }
        return this.orderedMultiLoad(ids, loadOptions, session);
    }

    private List<T> orderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        boolean idCoercionEnabled = this.isIdCoercionEnabled();
        JavaType<?> idType = this.getLoadable().getIdentifierMapping().getJavaType();
        int maxBatchSize = this.maxBatchSize(ids, loadOptions);
        ArrayList<Object> results = CollectionHelper.arrayList(ids.length);
        ArrayList<Object> idsInBatch = new ArrayList<Object>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        LockOptions lockOptions = AbstractMultiIdEntityLoader.lockOptions(loadOptions);
        for (int i = 0; i < ids.length; ++i) {
            EntityKey entityKey;
            Object id = idCoercionEnabled ? idType.coerce(ids[i], session) : ids[i];
            if (this.loadFromEnabledCaches(loadOptions, session, id, lockOptions, entityKey = new EntityKey(id, this.getLoadable().getEntityPersister()), results, i)) continue;
            idsInBatch.add(id);
            if (idsInBatch.size() >= maxBatchSize) {
                this.loadEntitiesById(idsInBatch, lockOptions, loadOptions, session);
                idsInBatch.clear();
            }
            results.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            this.loadEntitiesById(idsInBatch, lockOptions, loadOptions, session);
        }
        this.handleResults(loadOptions, session, elementPositionsLoadedByBatch, results);
        return results;
    }

    private static LockOptions lockOptions(MultiIdLoadOptions loadOptions) {
        return loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
    }

    protected abstract int maxBatchSize(Object[] var1, MultiIdLoadOptions var2);

    private void handleResults(MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session, List<Integer> elementPositionsLoadedByBatch, List<Object> results) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        for (Integer position : elementPositionsLoadedByBatch) {
            EntityKey entityKey = (EntityKey)results.get(position);
            session.getPersistenceContextInternal().getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
            Object entity = persistenceContext.getEntity(entityKey);
            Object result = entity == null || !loadOptions.isReturnOfDeletedEntitiesEnabled() && persistenceContext.getEntry(entity).getStatus().isDeletedOrGone() ? null : persistenceContext.proxyFor(entity);
            results.set(position, result);
        }
    }

    protected abstract void loadEntitiesById(List<Object> var1, LockOptions var2, MultiIdLoadOptions var3, SharedSessionContractImplementor var4);

    private boolean loadFromEnabledCaches(MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session, Object id, LockOptions lockOptions, EntityKey entityKey, List<Object> result, int i) {
        return (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) && this.isLoadFromCaches(loadOptions, entityKey, lockOptions, result, i, session);
    }

    private boolean isLoadFromCaches(MultiIdLoadOptions loadOptions, EntityKey entityKey, LockOptions lockOptions, List<Object> results, int i, SharedSessionContractImplementor session) {
        Object entity;
        CacheLoadHelper.PersistenceContextEntry entry;
        Object entity2;
        if (loadOptions.isSessionCheckingEnabled() && (entity2 = (entry = CacheLoadHelper.loadFromSessionCache(entityKey, lockOptions, LoadEventListener.GET, session)).entity()) != null) {
            Object result = loadOptions.isReturnOfDeletedEntitiesEnabled() || entry.isManaged() ? entity2 : null;
            results.add(i, result);
            return true;
        }
        if (loadOptions.isSecondLevelCacheCheckingEnabled() && (entity = this.loadFromSecondLevelCache(entityKey, lockOptions, session)) != null) {
            results.add(i, entity);
            return true;
        }
        return false;
    }

    protected List<T> unorderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        ArrayList results;
        LockOptions lockOptions = AbstractMultiIdEntityLoader.lockOptions(loadOptions);
        Object[] unresolvableIds = this.resolveInCachesIfEnabled(ids, loadOptions, lockOptions, session, (arg_0, arg_1, arg_2) -> AbstractMultiIdEntityLoader.lambda$unorderedMultiLoad$0(results = CollectionHelper.arrayList(ids.length), arg_0, arg_1, arg_2));
        if (!CollectionHelper.isEmpty(unresolvableIds)) {
            this.loadEntitiesWithUnresolvedIds(unresolvableIds, loadOptions, lockOptions, results, session);
            BatchFetchQueue batchFetchQueue = session.getPersistenceContextInternal().getBatchFetchQueue();
            EntityPersister persister = this.getLoadable().getEntityPersister();
            for (Object id : unresolvableIds) {
                if (id == null) continue;
                batchFetchQueue.removeBatchLoadableEntityKey(session.generateEntityKey(id, persister));
            }
        }
        return results;
    }

    protected abstract void loadEntitiesWithUnresolvedIds(Object[] var1, MultiIdLoadOptions var2, LockOptions var3, List<T> var4, SharedSessionContractImplementor var5);

    private <R> Object[] resolveInCachesIfEnabled(Object[] ids, @NonNull MultiIdLoadOptions loadOptions, @NonNull LockOptions lockOptions, SharedSessionContractImplementor session, ResolutionConsumer<R> resolutionConsumer) {
        return loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled() ? this.resolveInCaches(ids, loadOptions, lockOptions, session, resolutionConsumer) : ids;
    }

    private <R> Object[] resolveInCaches(Object[] ids, MultiIdLoadOptions loadOptions, LockOptions lockOptions, SharedSessionContractImplementor session, ResolutionConsumer<R> resolutionConsumer) {
        boolean idCoercionEnabled = this.isIdCoercionEnabled();
        JavaType<?> idType = this.getLoadable().getIdentifierMapping().getJavaType();
        List<Object> unresolvedIds = null;
        for (int i = 0; i < ids.length; ++i) {
            Object id = idCoercionEnabled ? idType.coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            unresolvedIds = this.loadFromCaches(loadOptions, lockOptions, resolutionConsumer, id, entityKey, unresolvedIds, i, session);
        }
        if (CollectionHelper.isEmpty(unresolvedIds)) {
            return null;
        }
        if (unresolvedIds.size() == ids.length) {
            return ids;
        }
        return this.toIdArray(unresolvedIds);
    }

    protected abstract Object[] toIdArray(List<Object> var1);

    private boolean isIdCoercionEnabled() {
        return !this.getSessionFactory().getSessionFactoryOptions().getJpaCompliance().isLoadByIdComplianceEnabled();
    }

    private <R> List<Object> loadFromCaches(MultiIdLoadOptions loadOptions, LockOptions lockOptions, ResolutionConsumer<R> resolutionConsumer, Object id, EntityKey entityKey, List<Object> unresolvedIds, int i, SharedSessionContractImplementor session) {
        Object cachedEntity;
        Object sessionEntity;
        CacheLoadHelper.PersistenceContextEntry entry = CacheLoadHelper.loadFromSessionCache(entityKey, lockOptions, LoadEventListener.GET, session);
        if (loadOptions.isSessionCheckingEnabled()) {
            sessionEntity = entry.entity();
            if (sessionEntity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !entry.isManaged()) {
                resolutionConsumer.consume(i, entityKey, null);
                return unresolvedIds;
            }
        } else {
            sessionEntity = null;
        }
        Object object = cachedEntity = sessionEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled() ? this.loadFromSecondLevelCache(entityKey, lockOptions, session) : sessionEntity;
        if (cachedEntity != null) {
            resolutionConsumer.consume(i, entityKey, cachedEntity);
        } else {
            if (unresolvedIds == null) {
                unresolvedIds = new ArrayList<Object>();
            }
            unresolvedIds.add(id);
        }
        return unresolvedIds;
    }

    private Object loadFromSecondLevelCache(EntityKey entityKey, LockOptions lockOptions, SharedSessionContractImplementor session) {
        EntityPersister persister = this.getLoadable().getEntityPersister();
        return session.loadFromSecondLevelCache(persister, entityKey, null, lockOptions.getLockMode());
    }

    private static /* synthetic */ void lambda$unorderedMultiLoad$0(List results, int position, EntityKey entityKey, Object resolvedRef) {
        results.add(resolvedRef);
    }

    public static interface ResolutionConsumer<T> {
        public void consume(int var1, EntityKey var2, T var3);
    }
}

