/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatableDomainType;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedMapJoin<L, K, V, S extends V>
extends SqmMapJoin<L, K, S>
implements SqmTreatedAttributeJoin<L, V, S> {
    private final SqmMapJoin<L, K, V> wrappedPath;
    private final SqmTreatableDomainType<S> treatTarget;

    public SqmTreatedMapJoin(SqmMapJoin<L, K, V> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedMapJoin(SqmMapJoin<L, K, V> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getTypeName(), alias), wrappedPath.getModel(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedMapJoin(NavigablePath navigablePath, SqmMapJoin<L, K, V> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getModel(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedMapJoin<L, K, V, S> copy(SqmCopyContext context) {
        SqmTreatedMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedMapJoin<L, K, V, S> path = context.registerCopy(this, new SqmTreatedMapJoin<L, K, V, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmMapJoin<L, K, V> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public TreatableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmBindableType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmTreatableDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public <S1 extends S> SqmTreatedMapJoin<L, K, S, S1> treatAs(Class<S1> treatJavaType) {
        return super.treatAs(treatJavaType);
    }

    @Override
    public <S1 extends S> SqmTreatedMapJoin<L, K, S, S1> treatAs(EntityDomainType<S1> treatTarget) {
        return super.treatAs(treatTarget);
    }

    @Override
    public <S1 extends S> SqmTreatedMapJoin<L, K, S, S1> treatAs(Class<S1> treatJavaType, String alias) {
        return super.treatAs(treatJavaType, alias);
    }

    @Override
    public <S1 extends S> SqmTreatedMapJoin<L, K, S, S1> treatAs(EntityDomainType<S1> treatTarget, String alias) {
        return super.treatAs(treatTarget, alias);
    }

    public SqmTreatedMapJoin<L, K, V, S> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedMapJoin)super.on((JpaExpression)restriction);
    }

    public SqmTreatedMapJoin<L, K, V, S> on(Expression<Boolean> restriction) {
        return (SqmTreatedMapJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedMapJoin<L, K, V, S> on(JpaPredicate ... restrictions) {
        return (SqmTreatedMapJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedMapJoin<L, K, V, S> on(Predicate ... restrictions) {
        return (SqmTreatedMapJoin)super.on(restrictions);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getTypeName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedMapJoin)) return false;
        SqmTreatedMapJoin that = (SqmTreatedMapJoin)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getTypeName(), that.treatTarget.getTypeName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getTypeName(), this.wrappedPath.getNavigablePath());
    }
}

