/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tuple.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleSimpleSqmPathSource<J>
implements SqmPathSource<J> {
    private final String localPathName;
    private final SqmDomainType<J> domainType;
    private final Bindable.BindableType jpaBindableType;

    public AnonymousTupleSimpleSqmPathSource(String localPathName, SqmDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        this.localPathName = localPathName;
        this.domainType = domainType;
        this.jpaBindableType = jpaBindableType;
    }

    public Class<J> getBindableJavaType() {
        return this.domainType.getJavaType();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public SqmDomainType<J> getPathType() {
        return this.domainType;
    }

    public Bindable.BindableType getBindableType() {
        return this.jpaBindableType;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.domainType.getExpressibleJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Basic paths cannot be dereferenced");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return new SqmBasicValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this, lhs, lhs.nodeBuilder());
    }
}

