/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public interface AdjustableBasicType<J>
extends BasicType<J> {
    default public <X> BasicType<X> resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<X> domainJtd) {
        JdbcType jdbcType = this.getJdbcType();
        if (jdbcType instanceof AdjustableJdbcType) {
            AdjustableJdbcType adjustableJdbcType = (AdjustableJdbcType)jdbcType;
            JdbcType resolvedJdbcType = adjustableJdbcType.resolveIndicatedType(indicators, domainJtd);
            if (resolvedJdbcType != jdbcType) {
                return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(domainJtd, resolvedJdbcType, this.getName());
            }
        } else {
            int resolvedJdbcTypeCode = indicators.resolveJdbcTypeCode(jdbcType.getDefaultSqlTypeCode());
            if (resolvedJdbcTypeCode != jdbcType.getDefaultSqlTypeCode()) {
                return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(domainJtd, indicators.getJdbcType(resolvedJdbcTypeCode), this.getName());
            }
        }
        return this;
    }
}

