/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.keycloak.Config;

public class TopologyInfo {
    private static final Logger logger = Logger.getLogger(TopologyInfo.class);
    private final String myNodeName;
    private final String mySiteName;
    private final boolean isGeneratedNodeName;

    @Deprecated(since="26.3", forRemoval=true)
    public TopologyInfo(EmbeddedCacheManager cacheManager, Config.Scope config, boolean embedded, String providerId) {
        this(cacheManager);
    }

    public TopologyInfo(EmbeddedCacheManager cacheManager) {
        TransportConfiguration transportConfig = cacheManager.getCacheManagerConfiguration().transport();
        Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cacheManager, Transport.class);
        if (transport == null) {
            String nodeName = transportConfig.nodeName();
            this.isGeneratedNodeName = nodeName == null || nodeName.isEmpty();
            this.myNodeName = this.isGeneratedNodeName ? TopologyInfo.generateNodeName() : nodeName;
        } else {
            this.myNodeName = transport.localNodeName();
            this.isGeneratedNodeName = false;
        }
        this.mySiteName = transportConfig.siteId();
    }

    private static String generateNodeName() {
        return "node_" + new SecureRandom().nextInt(1000000);
    }

    public String getMyNodeName() {
        return this.myNodeName;
    }

    public String getMySiteName() {
        return this.mySiteName;
    }

    public String toString() {
        return String.format("Node name: %s, Site name: %s", this.myNodeName, this.mySiteName);
    }

    public boolean amIOwner(Cache<?, ?> cache, Object key) {
        Address myAddress = cache.getCacheManager().getAddress();
        Address objectOwnerAddress = this.getOwnerAddress(cache, key);
        return Objects.equals(myAddress, objectOwnerAddress);
    }

    public String getRouteName(Cache<?, ?> cache, Object key) {
        if (cache.getCacheConfiguration().clustering().cacheMode().isClustered() && this.isGeneratedNodeName) {
            logger.warn((Object)"Clustered configuration used, but node name is not properly set. Make sure to start server with jboss.node.name property identifying cluster node");
        }
        if (this.isGeneratedNodeName) {
            return null;
        }
        Address address = this.getOwnerAddress(cache, key);
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return this.myNodeName;
        }
        org.jgroups.Address jgroupsAddress = TopologyInfo.toJGroupsAddress(address);
        String name = NameCache.get((org.jgroups.Address)jgroupsAddress);
        if (name == null) {
            Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cache.getCacheManager(), Transport.class);
            JChannel channel = ((JGroupsTransport)transport).getChannel();
            IpAddress ipAddress = (IpAddress)channel.getProtocolStack().getTransport().localPhysicalAddress();
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            name = String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort());
            logger.debugf("Address not found in NameCache. Fallback to %s", (Object)name);
        }
        return name;
    }

    private Address getOwnerAddress(Cache<?, ?> cache, Object key) {
        DistributionManager dist = cache.getAdvancedCache().getDistributionManager();
        return dist == null ? cache.getCacheManager().getAddress() : dist.getCacheTopology().getDistribution(key).primary();
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}

