/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.BaseRoleEvent;

@ProtoTypeId(value=65587)
public class RoleUpdatedEvent
extends BaseRoleEvent {
    @ProtoField(value=3)
    final String roleName;

    @ProtoFactory
    RoleUpdatedEvent(String id, String containerId, String roleName) {
        super(id, containerId);
        this.roleName = Objects.requireNonNull(roleName);
    }

    public static RoleUpdatedEvent create(String roleId, String roleName, String containerId) {
        return new RoleUpdatedEvent(roleId, containerId, roleName);
    }

    @Override
    public String toString() {
        return String.format("RoleUpdatedEvent [ roleId=%s, roleName=%s, containerId=%s ]", this.getId(), this.roleName, this.containerId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.roleUpdated(this.containerId, this.roleName, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleUpdatedEvent that = (RoleUpdatedEvent)o;
        return this.roleName.equals(that.roleName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.roleName.hashCode();
        return result;
    }
}

