/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.helper.MapUpdater;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.transaction.ClientSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;

public class AuthenticatedClientSessionUpdater
extends BaseUpdater<ClientSessionKey, RemoteAuthenticatedClientSessionEntity>
implements AuthenticatedClientSessionModel {
    private static final Factory ONLINE = new Factory(false);
    private static final Factory OFFLINE = new Factory(true);
    private final MapUpdater<String, String> notesUpdater;
    private final List<Consumer<RemoteAuthenticatedClientSessionEntity>> changes;
    private final boolean offline;
    private UserSessionModel userSession;
    private ClientModel client;
    private ClientSessionChangeLogTransaction clientTransaction;

    private AuthenticatedClientSessionUpdater(ClientSessionKey cacheKey, RemoteAuthenticatedClientSessionEntity cacheValue, long version, boolean offline, BaseUpdater.UpdaterState initialState) {
        super(cacheKey, cacheValue, version, initialState);
        this.offline = offline;
        if (cacheValue == null) {
            assert (initialState == BaseUpdater.UpdaterState.DELETED);
            this.notesUpdater = null;
            this.changes = List.of();
            return;
        }
        AuthenticatedClientSessionUpdater.initNotes(cacheValue);
        this.notesUpdater = new MapUpdater<String, String>(cacheValue.getNotes());
        this.changes = new ArrayList<Consumer<RemoteAuthenticatedClientSessionEntity>>(4);
    }

    public static UpdaterFactory<ClientSessionKey, RemoteAuthenticatedClientSessionEntity, AuthenticatedClientSessionUpdater> onlineFactory() {
        return ONLINE;
    }

    public static UpdaterFactory<ClientSessionKey, RemoteAuthenticatedClientSessionEntity, AuthenticatedClientSessionUpdater> offlineFactory() {
        return OFFLINE;
    }

    @Override
    public RemoteAuthenticatedClientSessionEntity apply(ClientSessionKey uuid, RemoteAuthenticatedClientSessionEntity entity) {
        AuthenticatedClientSessionUpdater.initNotes(entity);
        this.notesUpdater.applyChanges(entity.getNotes());
        this.changes.forEach(change -> change.accept(entity));
        if (this.isCreated()) {
            entity.setTimestamp(Math.max(entity.getTimestamp(), this.getTimestamp()));
            entity.setStarted(Math.max(entity.getStarted(), this.getStarted()));
        }
        return entity;
    }

    @Override
    public Expiration computeExpiration() {
        long maxIdle = SessionTimeouts.getClientSessionMaxIdleMs(this.userSession.getRealm(), this.client, this.offline, this.isUserSessionRememberMe(), this.getTimestamp());
        long lifespan = SessionTimeouts.getClientSessionLifespanMs(this.userSession.getRealm(), this.client, this.offline, this.isUserSessionRememberMe(), this.getStarted(), this.getUserSessionStarted());
        return new Expiration(maxIdle, lifespan);
    }

    public String getId() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).createId();
    }

    public int getStarted() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).getStarted();
    }

    public int getUserSessionStarted() {
        this.checkInitialized();
        return this.userSession.getStarted();
    }

    public boolean isUserSessionRememberMe() {
        this.checkInitialized();
        return this.userSession.isRememberMe();
    }

    public int getTimestamp() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.addAndApplyChange(entity -> entity.setTimestamp(Math.max(timestamp, entity.getTimestamp())));
    }

    public void detachFromUserSession() {
        this.clientTransaction.remove((ClientSessionKey)this.getKey());
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getNote(String name) {
        return this.notesUpdater.get(name);
    }

    public void setNote(String name, String value) {
        this.notesUpdater.put(name, value);
    }

    public void removeNote(String name) {
        this.notesUpdater.remove(name);
    }

    public Map<String, String> getNotes() {
        return this.notesUpdater;
    }

    public String getRedirectUri() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.addAndApplyChange(entity -> entity.setRedirectUri(uri));
    }

    public RealmModel getRealm() {
        return this.userSession.getRealm();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public String getAction() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).getAction();
    }

    public void setAction(String action) {
        this.addAndApplyChange(entity -> entity.setAction(action));
    }

    public String getProtocol() {
        return ((RemoteAuthenticatedClientSessionEntity)this.getValue()).getProtocol();
    }

    public void setProtocol(String method) {
        this.addAndApplyChange(entity -> entity.setProtocol(method));
    }

    public void restartClientSession() {
        this.addAndApplyChange(RemoteAuthenticatedClientSessionEntity::restart);
    }

    @Override
    public boolean isTransient() {
        return !this.isDeleted() && this.userSession.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT;
    }

    @Override
    protected boolean isUnchanged() {
        return this.changes.isEmpty() && this.notesUpdater.isUnchanged();
    }

    public synchronized void initialize(UserSessionModel userSession, ClientModel client, ClientSessionChangeLogTransaction clientTransaction) {
        this.userSession = Objects.requireNonNull(userSession);
        this.client = Objects.requireNonNull(client);
        this.clientTransaction = Objects.requireNonNull(clientTransaction);
    }

    public synchronized boolean isInitialized() {
        return this.userSession != null;
    }

    private void addAndApplyChange(Consumer<RemoteAuthenticatedClientSessionEntity> change) {
        this.changes.add(change);
        change.accept((RemoteAuthenticatedClientSessionEntity)this.getValue());
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not initialized yet!");
        }
    }

    private static void initNotes(RemoteAuthenticatedClientSessionEntity entity) {
        Map<String, String> notes = entity.getNotes();
        if (notes == null) {
            entity.setNotes(new HashMap<String, String>());
        }
    }

    private record Factory(boolean offline) implements UpdaterFactory<ClientSessionKey, RemoteAuthenticatedClientSessionEntity, AuthenticatedClientSessionUpdater>
    {
        @Override
        public AuthenticatedClientSessionUpdater create(ClientSessionKey key, RemoteAuthenticatedClientSessionEntity entity) {
            return new AuthenticatedClientSessionUpdater(key, Objects.requireNonNull(entity), -1L, this.offline, BaseUpdater.UpdaterState.CREATED);
        }

        @Override
        public AuthenticatedClientSessionUpdater wrapFromCache(ClientSessionKey key, RemoteAuthenticatedClientSessionEntity value, long version) {
            return new AuthenticatedClientSessionUpdater(key, Objects.requireNonNull(value), version, this.offline, BaseUpdater.UpdaterState.READ);
        }

        @Override
        public AuthenticatedClientSessionUpdater deleted(ClientSessionKey key) {
            return new AuthenticatedClientSessionUpdater(key, null, -1L, this.offline, BaseUpdater.UpdaterState.DELETED);
        }
    }
}

