/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.util.AbstractAlgorithmParametersSpiImpl;

public final class IteratedSaltedPasswordAlgorithmParametersSpiImpl
extends AbstractAlgorithmParametersSpiImpl<IteratedSaltedPasswordAlgorithmSpec> {
    protected Class<IteratedSaltedPasswordAlgorithmSpec> getParameterType() {
        return IteratedSaltedPasswordAlgorithmSpec.class;
    }

    protected void engineEncode(ASN1Encoder encoder, IteratedSaltedPasswordAlgorithmSpec parameterSpec) {
        encoder.startSequence();
        encoder.encodeInteger(parameterSpec.getIterationCount());
        encoder.encodeOctetString(parameterSpec.getSalt());
        encoder.endSequence();
    }

    protected IteratedSaltedPasswordAlgorithmSpec engineDecode(ASN1Decoder decoder) {
        decoder.startSequence();
        int iterationCount = decoder.decodeInteger().intValue();
        byte[] salt = decoder.decodeOctetString();
        decoder.endSequence();
        return new IteratedSaltedPasswordAlgorithmSpec(iterationCount, salt);
    }
}

