/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SAMLEncryptionAlgorithms
extends Enum<SAMLEncryptionAlgorithms> {
    public static final /* enum */ SAMLEncryptionAlgorithms RSA_OAEP = new SAMLEncryptionAlgorithms("RSA-OAEP", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2009/xmlenc11#rsa-oaep");
    public static final /* enum */ SAMLEncryptionAlgorithms RSA1_5 = new SAMLEncryptionAlgorithms("RSA1_5", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
    private final String[] xmlEncIdentifier;
    private final String keycloakIdentifier;
    private static final Map<String, SAMLEncryptionAlgorithms> forKeycloakIdentifier;
    private static final Map<String, SAMLEncryptionAlgorithms> forXMLEncIdentifier;
    private static final /* synthetic */ SAMLEncryptionAlgorithms[] $VALUES;

    public static SAMLEncryptionAlgorithms[] values() {
        return (SAMLEncryptionAlgorithms[])$VALUES.clone();
    }

    public static SAMLEncryptionAlgorithms valueOf(String name) {
        return Enum.valueOf(SAMLEncryptionAlgorithms.class, name);
    }

    private SAMLEncryptionAlgorithms(String keycloakIdentifier, String ... xmlEncIdentifier) {
        assert (xmlEncIdentifier.length > 0) : "xmlEncIdentifier should contain at least one identifier";
        this.xmlEncIdentifier = xmlEncIdentifier;
        this.keycloakIdentifier = keycloakIdentifier;
    }

    public String[] getXmlEncIdentifiers() {
        return this.xmlEncIdentifier;
    }

    public String getKeycloakIdentifier() {
        return this.keycloakIdentifier;
    }

    public static SAMLEncryptionAlgorithms forXMLEncIdentifier(String xmlEncIdentifier) {
        return forXMLEncIdentifier.get(xmlEncIdentifier);
    }

    public static SAMLEncryptionAlgorithms forKeycloakIdentifier(String keycloakIdentifier) {
        return forKeycloakIdentifier.get(keycloakIdentifier);
    }

    private static /* synthetic */ SAMLEncryptionAlgorithms[] $values() {
        return new SAMLEncryptionAlgorithms[]{RSA_OAEP, RSA1_5};
    }

    static {
        $VALUES = SAMLEncryptionAlgorithms.$values();
        HashMap<String, SAMLEncryptionAlgorithms> forKeycloakIdentifierTmp = new HashMap<String, SAMLEncryptionAlgorithms>();
        HashMap<String, SAMLEncryptionAlgorithms> forXMLEncIdentifierTmp = new HashMap<String, SAMLEncryptionAlgorithms>();
        for (SAMLEncryptionAlgorithms alg : SAMLEncryptionAlgorithms.values()) {
            forKeycloakIdentifierTmp.put(alg.getKeycloakIdentifier(), alg);
            for (String xmlAlg : alg.getXmlEncIdentifiers()) {
                forXMLEncIdentifierTmp.put(xmlAlg, alg);
            }
        }
        forKeycloakIdentifier = Collections.unmodifiableMap(forKeycloakIdentifierTmp);
        forXMLEncIdentifier = Collections.unmodifiableMap(forXMLEncIdentifierTmp);
    }
}

