import { BridgeRequest } from "../models/BridgeRequest";
import { MatrixRoom } from "matrix-appservice-bridge";
import { IrcBridge } from "./IrcBridge";
import { MatrixHandler, MatrixSimpleMessage } from "./MatrixHandler";
/**
 * For a given input event, try to parse out a command. This assumes
 * the event may be malformed.
 * @param event A matrix message event.
 * @param prefix The prefix for the message.
 * @returns A cmd (without prefix) and args
 */
export declare function parseCommandFromEvent(event: {
    content?: {
        body?: unknown;
    };
}, prefix?: string): {
    cmd: string;
    args: string[];
} | null;
export declare class AdminRoomHandler {
    private ircBridge;
    private matrixHandler;
    private readonly botUser;
    constructor(ircBridge: IrcBridge, matrixHandler: MatrixHandler);
    onAdminMessage(req: BridgeRequest, event: MatrixSimpleMessage, adminRoom: MatrixRoom): Promise<void>;
    private handleCommand;
    private handlePlumb;
    private handleUnlink;
    private handleJoin;
    private handleCmd;
    private handleWhois;
    private handleReconnect;
    private handleUsername;
    private handleStorePass;
    private handleRemovePass;
    private handleListRooms;
    private handleQuit;
    private handleNick;
    private handleFeature;
    private showBridgeVersion;
    private showHelp;
    private extractServerFromArgs;
    private getClientList;
    private getUserPermission;
}
