/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.tableeditors;

import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.time.LocalTime;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TimeTableEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private boolean autoAdjustMinimumTableRowHeight = true;
    public int clickCountToEdit = 1;
    private boolean matchTableBackgroundColor = true;
    private boolean matchTableSelectionBackgroundColor = true;
    private Border borderFocusedCell;
    private Border borderUnfocusedCell;
    private TimePicker timePicker;
    private int minimumRowHeightInPixels;

    public TimeTableEditor() {
        this(true, true, true);
    }

    public TimeTableEditor(boolean autoAdjustMinimumTableRowHeight, boolean matchTableBackgroundColor, boolean matchTableSelectionBackgroundColor) {
        this.autoAdjustMinimumTableRowHeight = autoAdjustMinimumTableRowHeight;
        this.matchTableBackgroundColor = matchTableBackgroundColor;
        this.matchTableSelectionBackgroundColor = matchTableSelectionBackgroundColor;
        JLabel exampleDefaultRenderer = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(new JTable(), "", true, true, 0, 0);
        this.borderFocusedCell = exampleDefaultRenderer.getBorder();
        this.borderUnfocusedCell = new EmptyBorder(1, 1, 1, 1);
        this.timePicker = new TimePicker();
        this.timePicker.setEnableArrowKeys(false);
        this.timePicker.setBorder(this.borderUnfocusedCell);
        this.timePicker.getComponentTimeTextField().setBorder(null);
        TimePickerSettings settings2 = this.timePicker.getSettings();
        settings2.setGapBeforeButtonPixels(0);
        settings2.setSizeTextFieldMinimumWidthDefaultOverride(false);
        settings2.setSizeTextFieldMinimumWidth(20);
        this.minimumRowHeightInPixels = this.timePicker.getPreferredSize().height + 1;
    }

    @Override
    public Object getCellEditorValue() {
        return this.timePicker.getTime();
    }

    public TimePicker getTimePicker() {
        return this.timePicker;
    }

    public TimePickerSettings getTimePickerSettings() {
        return this.timePicker.getSettings();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        this.zAdjustTableRowHeightIfNeeded(table);
        this.timePicker.getComponentTimeTextField().setScrollOffset(0);
        return this.timePicker;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setCellEditorValue(value);
        if (isSelected) {
            if (this.matchTableSelectionBackgroundColor) {
                this.timePicker.getComponentTimeTextField().setBackground(table.getSelectionBackground());
                this.timePicker.setBackground(table.getSelectionBackground());
            } else {
                this.timePicker.zDrawTextFieldIndicators();
            }
        }
        if (!isSelected) {
            if (this.matchTableBackgroundColor) {
                this.timePicker.getComponentTimeTextField().setBackground(table.getBackground());
                this.timePicker.setBackground(table.getBackground());
            } else {
                this.timePicker.zDrawTextFieldIndicators();
            }
        }
        if (hasFocus) {
            this.timePicker.setBorder(this.borderFocusedCell);
        } else {
            this.timePicker.setBorder(this.borderUnfocusedCell);
        }
        this.zAdjustTableRowHeightIfNeeded(table);
        this.timePicker.getComponentTimeTextField().setScrollOffset(0);
        return this.timePicker;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToEdit;
        }
        return true;
    }

    public void setCellEditorValue(Object value) {
        this.timePicker.clear();
        if (value == null) {
            return;
        }
        if (value instanceof LocalTime) {
            LocalTime nativeValue = (LocalTime)value;
            this.timePicker.setTime(nativeValue);
        } else {
            String text = value.toString();
            String shorterText = InternalUtilities.safeSubstring(text, 0, 100);
            this.timePicker.setText(shorterText);
        }
    }

    private void zAdjustTableRowHeightIfNeeded(JTable table) {
        if (!this.autoAdjustMinimumTableRowHeight) {
            return;
        }
        if (table.getRowHeight() < this.minimumRowHeightInPixels) {
            table.setRowHeight(this.minimumRowHeightInPixels);
        }
    }
}

