/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm.impl;

import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.impl.HelperContextImpl;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;

public class InstallerHelperContextImpl
extends HelperContextImpl
implements InstallerContext {
    @Override
    public void setInstallationDirectory(final File installationDirectory) {
        this.helperCommunication.executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            @Override
            protected void run(Context context) {
                ((InstallerContext)context).setInstallationDirectory(installationDirectory);
            }
        });
    }

    @Override
    public File getAdditionalUserJarsDir() {
        return this.helperCommunication.fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<File>(){

            @Override
            protected File fetchValue(Context context) throws UserCanceledException {
                return ContextImpl.getContextInt(context).getAdditionalUserJarsDir();
            }
        });
    }

    @Override
    public boolean isUpdateInstallation() {
        return this.helperCommunication.fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws UserCanceledException {
                return ((InstallerContext)context).isUpdateInstallation();
            }
        });
    }

    @Override
    public File getInstallerFile() {
        return this.helperCommunication.fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<File>(){

            @Override
            protected File fetchValue(Context context) throws UserCanceledException {
                return ((InstallerContext)context).getInstallerFile();
            }
        });
    }

    @Override
    public String getMediaName() {
        return this.helperCommunication.fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            @Override
            protected String fetchValue(Context context) throws UserCanceledException {
                return ((InstallerContext)context).getMediaName();
            }
        });
    }

    @Override
    public boolean installFile(File sourceFile, File destFile) throws UserCanceledException {
        return FileInstaller.getInstance().install(sourceFile, destFile);
    }

    @Override
    public boolean installFile(File sourceFile, File destFile, FileOptions options) throws UserCanceledException {
        return FileInstaller.getInstance().install(sourceFile, destFile, options);
    }

    @Override
    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    @Override
    public boolean installFile(File sourceFile, File destFile, FileOptions options, ProgressInterface progressInterface, int fromPercent, int toPercent) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, fromPercent, toPercent);
        }
        return FileInstaller.getInstance().install(sourceFile, destFile, options, progressInterface);
    }

    @Override
    public void installDirectory(File directory, UninstallMode uninstallMode) {
        FileInstaller.getInstance().createDirectory(directory, uninstallMode);
    }
}

