/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaSliderUI;
import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class AquaRangeSliderUI
extends AquaSliderUI {
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected static final int MOUSE_HANDLE_BOTH = 7;
    protected boolean hover;
    protected boolean second;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public AquaRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaRangeSliderUI((JSlider)c);
    }

    public void paint(Graphics g2, JComponent c) {
        this.second = false;
        super.paint(g2, c);
        Rectangle clip = g2.getClipBounds();
        this.second = true;
        Point p = this.adjustThumbForHighValue();
        if (clip.intersects(this.thumbRect)) {
            JRSUIConstants.Orientation orientation = this.slider.getOrientation() != 0 ? JRSUIConstants.Orientation.VERTICAL : JRSUIConstants.Orientation.HORIZONTAL;
            JRSUIConstants.State state = this.getState();
            this.paintThumb(g2, c, orientation, state);
        }
        this.restoreThumbForLowValue(p);
        this.second = false;
    }

    protected static boolean isActive(JComponent jcomponent) {
        if (jcomponent == null) {
            return true;
        }
        Object obj = jcomponent.getClientProperty("Frame.active");
        return !Boolean.FALSE.equals(obj);
    }

    JRSUIConstants.State getState() {
        if (!this.slider.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.fIsDragging) {
            return JRSUIConstants.State.PRESSED;
        }
        if (!AquaRangeSliderUI.isActive(this.slider)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected void restoreThumbForLowValue(Point p) {
        this.thumbRect.x = p.x;
        this.thumbRect.y = p.y;
    }

    protected Point adjustThumbForHighValue() {
        Point p = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
        return p;
    }

    protected void adjustSnapHighValue() {
        int sliderValue;
        int snappedValue = sliderValue = ((RangeSlider)this.slider).getHighValue();
        int majorTickSpacing = this.slider.getMajorTickSpacing();
        int minorTickSpacing = this.slider.getMinorTickSpacing();
        int tickSpacing = 0;
        if (minorTickSpacing > 0) {
            tickSpacing = minorTickSpacing;
        } else if (majorTickSpacing > 0) {
            tickSpacing = majorTickSpacing;
        }
        if (tickSpacing != 0) {
            if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                int whichTick = Math.round(temp);
                snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
            }
            if (snappedValue != sliderValue) {
                ((RangeSlider)this.slider).setHighValue(snappedValue);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapHighValue();
        }
        super.calculateThumbLocation();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener(super.createTrackListener(slider));
    }

    protected int getMouseHandle(int x, int y) {
        int maxX;
        Rectangle rect = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        boolean inMin = false;
        boolean inMax = false;
        if (this.thumbRect.contains(x, y)) {
            inMin = true;
        }
        Point p = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(x, y)) {
            inMax = true;
        }
        this.restoreThumbForLowValue(p);
        if (inMin && inMax) {
            return 7;
        }
        if (inMin) {
            return 1;
        }
        if (inMax) {
            return 2;
        }
        if (this.slider.getOrientation() == 1) {
            int maxY;
            int minY = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle midRect = new Rectangle(rect.x, Math.min(minY, maxY = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rect.width, Math.abs(maxY - minY) - this.thumbRect.height);
            if (midRect.contains(x, y)) {
                return 4;
            }
            int sy = rect.y + Math.max(minY, maxY) + this.thumbRect.height / 2;
            Rectangle lowerRect = new Rectangle(rect.x, sy, rect.width, rect.y + rect.height - sy);
            if (lowerRect.contains(x, y)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle upperRect = new Rectangle(rect.x, rect.y, rect.width, Math.min(maxY, minY) - this.thumbRect.height / 2);
            if (upperRect.contains(x, y)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int minX = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle midRect = new Rectangle(Math.min(minX, maxX = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rect.y, Math.abs(maxX - minX) - this.thumbRect.width, rect.height);
        if (midRect.contains(x, y)) {
            return 4;
        }
        Rectangle lowerRect = new Rectangle(rect.x, rect.y, Math.min(minX, maxX) - this.thumbRect.width / 2 - rect.x, rect.height);
        if (lowerRect.contains(x, y)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int sx = rect.x + Math.abs(maxX - minX) + this.thumbRect.width / 2;
        Rectangle upperRect = new Rectangle(sx, rect.y, rect.width - sx, rect.height);
        if (upperRect.contains(x, y)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics g2) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.rollover2 : this.rollover1);
            field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set((Object)this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(g2);
    }

    protected void setMouseRollover(int handle) {
        switch (handle) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    protected void setMousePressed(int handle) {
        switch (handle) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: 
            case 7: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    protected void setMouseReleased(int handle) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point p = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByBlock");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object clientProperty = this.slider.getClientProperty("RangeSlider.mousePosition");
            int oldValue = clientProperty == null ? this.slider.getValue() : (Boolean.TRUE.equals(clientProperty) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int delta = 1 * (direction > 0 ? 1 : -1);
            this.slider.putClientProperty("RangeSlider.adjustAction", "scrollByUnit");
            if (clientProperty == null) {
                this.slider.setValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else if (Boolean.TRUE.equals(clientProperty)) {
                ((RangeSlider)this.slider).setLowValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            } else {
                ((RangeSlider)this.slider).setHighValue(Math.max(Math.min(oldValue + delta, this.slider.getMaximum()), this.slider.getMinimum()));
            }
            this.slider.putClientProperty("RangeSlider.adjustAction", null);
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener listener) {
            super((BasicSliderUI)((Object)AquaRangeSliderUI.this));
            this._listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AquaRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (AquaRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                AquaRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = AquaRangeSliderUI.this.getMouseHandle(e.getX(), e.getY());
            AquaRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4) {
                this.handleOffset = AquaRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() - AquaRangeSliderUI.this.yPositionForValue(((RangeSlider)AquaRangeSliderUI.this.slider).getLowValue()) : e.getX() - AquaRangeSliderUI.this.xPositionForValue(((RangeSlider)AquaRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = AquaRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
                AquaRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(e);
                AquaRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int newValue;
            if (!AquaRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int newLocation = AquaRangeSliderUI.this.slider.getOrientation() == 1 ? e.getY() : e.getX();
            int n = newValue = AquaRangeSliderUI.this.slider.getOrientation() == 1 ? AquaRangeSliderUI.this.valueForYPosition(newLocation) : AquaRangeSliderUI.this.valueForXPosition(newLocation);
            if (newValue < AquaRangeSliderUI.this.slider.getModel().getMinimum()) {
                newValue = AquaRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (newValue > AquaRangeSliderUI.this.slider.getModel().getMaximum()) {
                newValue = AquaRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 7) {
                if (newLocation - this.mouseStartLocation >= 1) {
                    this.handle = 2;
                } else if (newLocation - this.mouseStartLocation <= -1) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)AquaRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(newValue, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), newValue));
                    break;
                }
                case 4: {
                    int delta;
                    if (!((RangeSlider)AquaRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n2 = delta = AquaRangeSliderUI.this.slider.getOrientation() == 1 ? AquaRangeSliderUI.this.valueForYPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue() : AquaRangeSliderUI.this.valueForXPosition(newLocation - this.handleOffset) - rangeSlider.getLowValue();
                    if (delta < 0 && rangeSlider.getLowValue() + delta < rangeSlider.getMinimum()) {
                        delta = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (delta > 0 && rangeSlider.getHighValue() + delta > rangeSlider.getMaximum()) {
                        delta = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (delta == 0) break;
                    rangeSlider.setLowValue(rangeSlider.getLowValue() + delta);
                    rangeSlider.setHighValue(rangeSlider.getHighValue() + delta);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AquaRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            AquaRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(e);
        }

        private void setCursor(int c) {
            Cursor cursor = Cursor.getPredefinedCursor(c);
            if (AquaRangeSliderUI.this.slider.getCursor() != cursor) {
                AquaRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!AquaRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int handle = AquaRangeSliderUI.this.getMouseHandle(e.getX(), e.getY());
            AquaRangeSliderUI.this.setMouseRollover(handle);
            switch (handle) {
                case 1: 
                case 2: 
                case 7: {
                    this.setCursor(0);
                    break;
                }
                case 4: {
                    if (AquaRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)AquaRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AquaRangeSliderUI.this.slider.getModel().setValue(AquaRangeSliderUI.this.slider.getModel().getMinimum());
                AquaRangeSliderUI.this.slider.getModel().setExtent(AquaRangeSliderUI.this.slider.getModel().getMaximum() - AquaRangeSliderUI.this.slider.getModel().getMinimum());
                AquaRangeSliderUI.this.slider.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AquaRangeSliderUI.this.hover = true;
            AquaRangeSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AquaRangeSliderUI.this.hover = false;
            AquaRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

