/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicGripperUI
extends GripperUI {
    private int _size;
    protected ThemePainter _painter;
    protected Painter _gripperPainter;

    public static ComponentUI createUI(JComponent c) {
        return new BasicGripperUI();
    }

    @Override
    public void installUI(JComponent c) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("Gripper.painter");
        this.installDefaults((Gripper)c);
        this.installListeners((Gripper)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this._painter = null;
        this._gripperPainter = null;
        this.uninstallDefaults((Gripper)c);
        this.uninstallListeners((Gripper)c);
    }

    protected void installDefaults(Gripper s2) {
        this._size = UIDefaultsLookup.getInt("Gripper.size");
    }

    protected void uninstallDefaults(Gripper s2) {
    }

    protected MouseListener createMouseListener() {
        return new GripperMouseListener();
    }

    protected void installListeners(Gripper g2) {
        MouseListener listener = this.createMouseListener();
        if (listener != null) {
            g2.putClientProperty(this, listener);
            g2.addMouseListener(listener);
        }
    }

    protected void uninstallListeners(Gripper g2) {
        MouseListener listener = (MouseListener)g2.getClientProperty(this);
        g2.putClientProperty(this, null);
        if (listener != null) {
            g2.removeMouseListener(listener);
        }
    }

    protected void paintBackground(Graphics g2, Gripper b) {
        Rectangle rect = new Rectangle(0, 0, b.getWidth(), b.getHeight());
        if (b.isRollover()) {
            this.getPainter().paintButtonBackground(b, g2, rect, 0, 2);
        } else if (b.isOpaque()) {
            this.getPainter().paintButtonBackground(b, g2, rect, 0, b.isSelected() ? 3 : 0, false);
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(g2, rect, 0);
            }
        }
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        int state;
        Gripper gripper = (Gripper)c;
        this.paintBackground(g2, gripper);
        int n = state = gripper.isSelected() ? 3 : 0;
        if (this._gripperPainter == null) {
            this.getPainter().paintGripper(c, g2, new Rectangle(0, 0, c.getWidth(), c.getHeight()), gripper.getOrientation(), state);
        } else {
            this._gripperPainter.paint(c, g2, new Rectangle(0, 0, c.getWidth(), c.getHeight()), gripper.getOrientation(), state);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(this._size, this._size);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Gripper gripper = (Gripper)c;
        if (gripper.getOrientation() == 0) {
            return new Dimension(this._size, c.getParent().getHeight());
        }
        return new Dimension(c.getParent().getWidth(), this._size);
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    class GripperMouseListener
    extends MouseAdapter {
        GripperMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            if (e.getSource() instanceof Gripper && ((Gripper)e.getSource()).isRolloverEnabled()) {
                ((Gripper)e.getSource()).setRollover(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (e.getSource() instanceof Gripper && ((Gripper)e.getSource()).isRolloverEnabled()) {
                ((Gripper)e.getSource()).setRollover(false);
            }
        }
    }
}

