/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.AbstractPatternPanel;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.LocalizableStringValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.search.PatternMatcher;

public class JXSearchPanel
extends AbstractPatternPanel {
    public static final String MATCH_RULE_ACTION_COMMAND = "selectMatchRule";
    private JXComboBox searchCriteria;
    private List<PatternMatcher> patternMatchers;

    public JXSearchPanel() {
        this.initComponents();
        this.build();
        this.initActions();
        this.bind();
        this.getPatternModel().setIncremental(true);
    }

    public void addPatternMatcher(PatternMatcher matcher) {
        this.getPatternMatchers().add(matcher);
        this.updateFieldName(matcher);
    }

    public void setFieldName(String name) {
        String old = this.searchLabel.getText();
        this.searchLabel.setText(name);
        this.firePropertyChange("fieldName", old, this.searchLabel.getText());
    }

    public String getFieldName() {
        return this.searchLabel.getText();
    }

    public Pattern getPattern() {
        return this.patternModel.getPattern();
    }

    protected void updateFieldName(PatternMatcher matcher) {
        if (this.searchLabel.getText().length() == 0) {
            this.searchLabel.setText("Field");
        }
    }

    @Override
    public void match() {
        Iterator<PatternMatcher> iter = this.getPatternMatchers().iterator();
        while (iter.hasNext()) {
            iter.next().setPattern(this.getPattern());
        }
    }

    public void updateMatchRule() {
        this.getPatternModel().setMatchRule((String)this.searchCriteria.getSelectedItem());
    }

    private List<PatternMatcher> getPatternMatchers() {
        if (this.patternMatchers == null) {
            this.patternMatchers = new ArrayList<PatternMatcher>();
        }
        return this.patternMatchers;
    }

    @Override
    protected void initExecutables() {
        super.initExecutables();
        this.getActionMap().put(MATCH_RULE_ACTION_COMMAND, this.createBoundAction(MATCH_RULE_ACTION_COMMAND, "updateMatchRule"));
    }

    @Override
    protected void bind() {
        super.bind();
        List<String> matchRules = this.getPatternModel().getMatchRules();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(matchRules.toArray());
        model.setSelectedItem(this.getPatternModel().getMatchRule());
        this.searchCriteria.setModel(model);
        this.searchCriteria.setAction(this.getAction(MATCH_RULE_ACTION_COMMAND));
        this.searchCriteria.setRenderer((ListCellRenderer)new DefaultListRenderer(this.createStringValue(this.getLocale())));
    }

    private StringValue createStringValue(Locale locale) {
        HashMap<Object, String> keys2 = new HashMap<Object, String>();
        keys2.put("contains", "contains");
        keys2.put("endsWith", "endsWith");
        keys2.put("equals", "equals");
        keys2.put("startsWith", "startsWith");
        return new LocalizableStringValue(keys2, "Search.", locale);
    }

    @Override
    protected void updateLocaleState(Locale locale) {
        super.updateLocaleState(locale);
        this.searchCriteria.setRenderer((ListCellRenderer)new DefaultListRenderer(this.createStringValue(locale)));
    }

    private void build() {
        this.add(this.searchLabel);
        this.add(this.searchCriteria);
        this.add(this.searchField);
        this.add(this.matchCheck);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.searchCriteria = new JXComboBox();
    }
}

