--[[
   Crimson Gauntlet, Digital Battleground

   Some light circuit background.
--]]

-- We use the default background too!
local starfield = require "bkg.lib.starfield"
local bgshaders = require "bkg.lib.bgshaders"
local love_shaders = require 'love_shaders'
local nebula = require "bkg.lib.nebula"

local shader, scircuit

function background ()
   -- Shader isn't too expensive, but we try to respect nebu_scale to an
   -- extent.
   local sf = math.max( 1, bgshaders.scale_factor_default() / 2 )

   -- Initialize the shader
   shader = love_shaders.circuit{ strength=sf }
   scircuit = bgshaders.init( shader, sf )

   -- Default nebula background (no star)
   starfield.init{ nolocalstars = true }

   -- Let's add big nebula because we can
   nebula.init{ size=3000, movemod=0.2, opacity=50 }

   -- Slightly blue
   gfx.lightAmbient( 0.6, 0.8, 1.0, 2 )
   gfx.lightIntensity( 0.5 * gfx.lightIntensityGet() )
end

renderbg = starfield.render

function renderfg( dt )
   -- Get camera properties
   --local x, y = camera.pos():get()
   local z = camera.getZoom()
   shader:send( "u_camera", 0, 0, z )

   scircuit:render( dt, {1, 1, 1, 0.03} )
end
