/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

public final class LegacyDirectWriter {
    final int bitsPerValue;
    final long numValues;
    final DataOutput output;
    long count;
    boolean finished;
    int off;
    final byte[] nextBlocks;
    final long[] nextValues;
    final PackedInts.Encoder encoder;
    final int iterations;
    static final int[] SUPPORTED_BITS_PER_VALUE = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64};

    LegacyDirectWriter(DataOutput output, long numValues, int bitsPerValue) {
        this.output = output;
        this.numValues = numValues;
        this.bitsPerValue = bitsPerValue;
        this.encoder = PackedInts.getEncoder((PackedInts.Format)PackedInts.Format.PACKED, (int)2, (int)bitsPerValue);
        this.iterations = LegacyDirectWriter.computeIterations(this.encoder, (int)Math.min(numValues, Integer.MAX_VALUE), 1024);
        this.nextBlocks = new byte[this.iterations * this.encoder.byteBlockCount()];
        this.nextValues = new long[this.iterations * this.encoder.byteValueCount()];
    }

    private static int computeIterations(PackedInts.Encoder encoder, int valueCount, int ramBudget) {
        int iterations = ramBudget / (encoder.byteBlockCount() + 8 * encoder.byteValueCount());
        if (iterations == 0) {
            return 1;
        }
        if ((iterations - 1) * encoder.byteValueCount() >= valueCount) {
            return (int)Math.ceil((double)valueCount / (double)encoder.byteValueCount());
        }
        return iterations;
    }

    public void add(long l) throws IOException {
        assert (this.bitsPerValue == 64 || l >= 0L && l <= PackedInts.maxValue((int)this.bitsPerValue)) : this.bitsPerValue;
        assert (!this.finished);
        if (this.count >= this.numValues) {
            throw new EOFException("Writing past end of stream");
        }
        this.nextValues[this.off++] = l;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        ++this.count;
    }

    private void flush() throws IOException {
        this.encoder.encode(this.nextValues, 0, this.nextBlocks, 0, this.iterations);
        int blockCount = (int)PackedInts.Format.PACKED.byteCount(2, this.off, this.bitsPerValue);
        this.output.writeBytes(this.nextBlocks, blockCount);
        Arrays.fill(this.nextValues, 0L);
        this.off = 0;
    }

    public void finish() throws IOException {
        if (this.count != this.numValues) {
            throw new IllegalStateException("Wrong number of values added, expected: " + this.numValues + ", got: " + this.count);
        }
        assert (!this.finished);
        this.flush();
        for (int i = 0; i < 3; ++i) {
            this.output.writeByte((byte)0);
        }
        this.finished = true;
    }

    public static LegacyDirectWriter getInstance(DataOutput output, long numValues, int bitsPerValue) {
        if (Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsPerValue) < 0) {
            throw new IllegalArgumentException("Unsupported bitsPerValue " + bitsPerValue + ". Did you use bitsRequired?");
        }
        return new LegacyDirectWriter(output, numValues, bitsPerValue);
    }

    private static int roundBits(int bitsRequired) {
        int index = Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsRequired);
        if (index < 0) {
            return SUPPORTED_BITS_PER_VALUE[-index - 1];
        }
        return bitsRequired;
    }

    public static int bitsRequired(long maxValue) {
        return LegacyDirectWriter.roundBits(PackedInts.bitsRequired((long)maxValue));
    }

    public static int unsignedBitsRequired(long maxValue) {
        return LegacyDirectWriter.roundBits(PackedInts.unsignedBitsRequired((long)maxValue));
    }
}

