/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.plain.histograms;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.internal.hppc.LongIntHashMap;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

final class HistogramCollector
implements Collector {
    private final String field;
    private final long bucketWidth;
    private final int maxBuckets;
    private final LongIntHashMap counts;

    HistogramCollector(String field, long bucketWidth, int maxBuckets) {
        this.field = field;
        this.bucketWidth = bucketWidth;
        this.maxBuckets = maxBuckets;
        this.counts = new LongIntHashMap();
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        FieldInfo fi = context.reader().getFieldInfos().fieldInfo(this.field);
        if (fi == null) {
            throw new CollectionTerminatedException();
        }
        if (fi.getDocValuesType() != DocValuesType.NUMERIC && fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            throw new IllegalStateException("Expected numeric field, but got doc-value type: " + String.valueOf(fi.getDocValuesType()));
        }
        SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.field);
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton == null) {
            return new HistogramNaiveLeafCollector(values, this.bucketWidth, this.maxBuckets, this.counts);
        }
        DocValuesSkipper skipper = context.reader().getDocValuesSkipper(this.field);
        if (skipper != null) {
            long leafMinBucket = Math.floorDiv(skipper.minValue(), this.bucketWidth);
            long leafMaxBucket = Math.floorDiv(skipper.maxValue(), this.bucketWidth);
            if (leafMaxBucket - leafMinBucket <= 1024L) {
                return new HistogramLeafCollector(singleton, skipper, this.bucketWidth, this.maxBuckets, this.counts);
            }
        }
        return new HistogramNaiveSingleValuedLeafCollector(singleton, this.bucketWidth, this.maxBuckets, this.counts);
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    LongIntHashMap getCounts() {
        return this.counts;
    }

    static void checkMaxBuckets(int size, int maxBuckets) {
        if (size > maxBuckets) {
            throw new IllegalStateException("Collected " + size + " buckets, which is more than the configured max number of buckets: " + maxBuckets);
        }
    }

    private static class HistogramNaiveLeafCollector
    implements LeafCollector {
        private final SortedNumericDocValues values;
        private final long bucketWidth;
        private final int maxBuckets;
        private final LongIntHashMap counts;

        HistogramNaiveLeafCollector(SortedNumericDocValues values, long bucketWidth, int maxBuckets, LongIntHashMap counts) {
            this.values = values;
            this.bucketWidth = bucketWidth;
            this.maxBuckets = maxBuckets;
            this.counts = counts;
        }

        public void setScorer(Scorable scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                int valueCount = this.values.docValueCount();
                long prevBucket = Long.MIN_VALUE;
                for (int i = 0; i < valueCount; ++i) {
                    long value = this.values.nextValue();
                    long bucket = Math.floorDiv(value, this.bucketWidth);
                    if (bucket == prevBucket) continue;
                    this.counts.addTo(bucket, 1);
                    HistogramCollector.checkMaxBuckets(this.counts.size(), this.maxBuckets);
                    prevBucket = bucket;
                }
            }
        }
    }

    private static class HistogramLeafCollector
    implements LeafCollector {
        private final NumericDocValues values;
        private final DocValuesSkipper skipper;
        private final long bucketWidth;
        private final int maxBuckets;
        private final int[] counts;
        private final long leafMinBucket;
        private final LongIntHashMap collectorCounts;
        private int upToInclusive = -1;
        private boolean upToSameBucket;
        private int upToBucketIndex;

        HistogramLeafCollector(NumericDocValues values, DocValuesSkipper skipper, long bucketWidth, int maxBuckets, LongIntHashMap collectorCounts) {
            this.values = values;
            this.skipper = skipper;
            this.bucketWidth = bucketWidth;
            this.maxBuckets = maxBuckets;
            this.collectorCounts = collectorCounts;
            this.leafMinBucket = Math.floorDiv(skipper.minValue(), bucketWidth);
            long leafMaxBucket = Math.floorDiv(skipper.maxValue(), bucketWidth);
            this.counts = new int[Math.toIntExact(leafMaxBucket - this.leafMinBucket + 1L)];
        }

        public void setScorer(Scorable scorer) throws IOException {
        }

        private void advanceSkipper(int doc) throws IOException {
            if (doc > this.skipper.maxDocID(0)) {
                this.skipper.advance(doc);
            }
            this.upToSameBucket = false;
            if (this.skipper.minDocID(0) > doc) {
                this.upToInclusive = this.skipper.minDocID(0) - 1;
                return;
            }
            this.upToInclusive = this.skipper.maxDocID(0);
            for (int level = 0; level < this.skipper.numLevels(); ++level) {
                int totalDocsAtLevel = this.skipper.maxDocID(level) - this.skipper.minDocID(level) + 1;
                long minBucket = Math.floorDiv(this.skipper.minValue(level), this.bucketWidth);
                long maxBucket = Math.floorDiv(this.skipper.maxValue(level), this.bucketWidth);
                if (this.skipper.docCount(level) != totalDocsAtLevel || minBucket != maxBucket) break;
                this.upToInclusive = this.skipper.maxDocID(level);
                this.upToSameBucket = true;
                this.upToBucketIndex = (int)(minBucket - this.leafMinBucket);
            }
        }

        public void collect(int doc) throws IOException {
            if (doc > this.upToInclusive) {
                this.advanceSkipper(doc);
            }
            if (this.upToSameBucket) {
                int n = this.upToBucketIndex;
                this.counts[n] = this.counts[n] + 1;
            } else if (this.values.advanceExact(doc)) {
                long value = this.values.longValue();
                long bucket = Math.floorDiv(value, this.bucketWidth);
                int n = (int)(bucket - this.leafMinBucket);
                this.counts[n] = this.counts[n] + 1;
            }
        }

        public void collect(DocIdStream stream) throws IOException {
            while (true) {
                int upToExclusive;
                if ((upToExclusive = this.upToInclusive + 1) < 0) {
                    upToExclusive = Integer.MAX_VALUE;
                }
                if (this.upToSameBucket) {
                    int n = this.upToBucketIndex;
                    this.counts[n] = this.counts[n] + stream.count(upToExclusive);
                } else {
                    stream.forEach(upToExclusive, this::collect);
                }
                if (!stream.mayHaveRemaining()) break;
                this.advanceSkipper(upToExclusive);
            }
        }

        public void finish() throws IOException {
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] == 0) continue;
                this.collectorCounts.addTo(this.leafMinBucket + (long)i, this.counts[i]);
            }
            HistogramCollector.checkMaxBuckets(this.collectorCounts.size(), this.maxBuckets);
        }
    }

    private static class HistogramNaiveSingleValuedLeafCollector
    implements LeafCollector {
        private final NumericDocValues values;
        private final long bucketWidth;
        private final int maxBuckets;
        private final LongIntHashMap counts;

        HistogramNaiveSingleValuedLeafCollector(NumericDocValues values, long bucketWidth, int maxBuckets, LongIntHashMap counts) {
            this.values = values;
            this.bucketWidth = bucketWidth;
            this.maxBuckets = maxBuckets;
            this.counts = counts;
        }

        public void setScorer(Scorable scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                long value = this.values.longValue();
                long bucket = Math.floorDiv(value, this.bucketWidth);
                this.counts.addTo(bucket, 1);
                HistogramCollector.checkMaxBuckets(this.counts.size(), this.maxBuckets);
            }
        }
    }
}

