/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;

class ScaleIndexShardResponse
implements Writeable {
    private final ShardId shardId;
    private final boolean needsSync;
    private final int uncommittedOperations;

    ScaleIndexShardResponse(ShardId shardId, boolean needsSync, int uncommittedOperations) {
        this.shardId = shardId;
        this.needsSync = needsSync;
        this.uncommittedOperations = uncommittedOperations;
    }

    ScaleIndexShardResponse(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.needsSync = in.readBoolean();
        this.uncommittedOperations = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeBoolean(this.needsSync);
        out.writeVInt(this.uncommittedOperations);
    }

    ShardId getShardId() {
        return this.shardId;
    }

    boolean needsSync() {
        return this.needsSync;
    }

    boolean hasUncommittedOperations() {
        return this.uncommittedOperations > 0;
    }
}

