/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.pagination;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.pagination.PageToken;
import org.opensearch.action.pagination.PaginationStrategy;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;

public class IndexPaginationStrategy
implements PaginationStrategy<String> {
    private static final String DEFAULT_INDICES_PAGINATED_ENTITY = "indices";
    protected static final Comparator<IndexMetadata> ASC_COMPARATOR = (metadata1, metadata2) -> {
        if (metadata1.getCreationDate() == metadata2.getCreationDate()) {
            return metadata1.getIndex().getName().compareTo(metadata2.getIndex().getName());
        }
        return Long.compare(metadata1.getCreationDate(), metadata2.getCreationDate());
    };
    protected static final Comparator<IndexMetadata> DESC_COMPARATOR = (metadata1, metadata2) -> {
        if (metadata1.getCreationDate() == metadata2.getCreationDate()) {
            return metadata2.getIndex().getName().compareTo(metadata1.getIndex().getName());
        }
        return Long.compare(metadata2.getCreationDate(), metadata1.getCreationDate());
    };
    private final PageToken pageToken;
    private final List<String> requestedIndices;

    public IndexPaginationStrategy(PageParams pageParams, ClusterState clusterState) {
        IndexStrategyToken requestedToken = Objects.isNull(pageParams.getRequestedToken()) || pageParams.getRequestedToken().isEmpty() ? null : new IndexStrategyToken(pageParams.getRequestedToken());
        List<IndexMetadata> sortedIndices = IndexPaginationStrategy.getEligibleIndices(clusterState, pageParams.getSort(), Objects.isNull(requestedToken) ? null : requestedToken.lastIndexName, Objects.isNull(requestedToken) ? null : Long.valueOf(requestedToken.lastIndexCreationTime));
        List<IndexMetadata> metadataSublist = this.getMetadataSubList(sortedIndices, pageParams.getSize());
        this.requestedIndices = metadataSublist.stream().map(metadata -> metadata.getIndex().getName()).collect(Collectors.toList());
        this.pageToken = this.getResponseToken(pageParams.getSize(), sortedIndices.size(), metadataSublist.isEmpty() ? null : metadataSublist.get(metadataSublist.size() - 1));
    }

    private static List<IndexMetadata> getEligibleIndices(ClusterState clusterState, String sortOrder, String lastIndexName, Long lastIndexCreationTime) {
        if (Objects.isNull(lastIndexName) || Objects.isNull(lastIndexCreationTime)) {
            return PaginationStrategy.getSortedIndexMetadata(clusterState, "asc".equals(sortOrder) ? ASC_COMPARATOR : DESC_COMPARATOR);
        }
        return PaginationStrategy.getSortedIndexMetadata(clusterState, IndexPaginationStrategy.getMetadataFilter(sortOrder, lastIndexName, lastIndexCreationTime), "asc".equals(sortOrder) ? ASC_COMPARATOR : DESC_COMPARATOR);
    }

    private static Predicate<IndexMetadata> getMetadataFilter(String sortOrder, String lastIndexName, Long lastIndexCreationTime) {
        if (Objects.isNull(lastIndexName) || Objects.isNull(lastIndexCreationTime)) {
            return indexMetadata -> true;
        }
        return IndexPaginationStrategy.getIndexCreateTimeFilter(sortOrder, lastIndexName, lastIndexCreationTime);
    }

    protected static Predicate<IndexMetadata> getIndexCreateTimeFilter(String sortOrder, String lastIndexName, Long lastIndexCreationTime) {
        boolean isAscendingSort = sortOrder.equals("asc");
        return metadata -> {
            if (metadata.getCreationDate() == lastIndexCreationTime.longValue()) {
                return isAscendingSort ? metadata.getIndex().getName().compareTo(lastIndexName) > 0 : metadata.getIndex().getName().compareTo(lastIndexName) < 0;
            }
            return isAscendingSort ? metadata.getCreationDate() > lastIndexCreationTime : metadata.getCreationDate() < lastIndexCreationTime;
        };
    }

    private List<IndexMetadata> getMetadataSubList(List<IndexMetadata> sortedIndices, int pageSize) {
        if (sortedIndices.isEmpty()) {
            return new ArrayList<IndexMetadata>();
        }
        return sortedIndices.subList(0, Math.min(pageSize, sortedIndices.size()));
    }

    private PageToken getResponseToken(int pageSize, int totalIndices, IndexMetadata lastIndex) {
        if (totalIndices <= pageSize) {
            return new PageToken(null, DEFAULT_INDICES_PAGINATED_ENTITY);
        }
        return new PageToken(new IndexStrategyToken(lastIndex.getCreationDate(), lastIndex.getIndex().getName()).generateEncryptedToken(), DEFAULT_INDICES_PAGINATED_ENTITY);
    }

    @Override
    public PageToken getResponseToken() {
        return this.pageToken;
    }

    @Override
    public List<String> getRequestedEntities() {
        return Objects.isNull(this.requestedIndices) ? new ArrayList() : this.requestedIndices;
    }

    public static class IndexStrategyToken {
        private static final String JOIN_DELIMITER = "|";
        private static final String SPLIT_REGEX = "\\|";
        private static final int CREATE_TIME_POS_IN_TOKEN = 0;
        private static final int INDEX_NAME_POS_IN_TOKEN = 1;
        private final long lastIndexCreationTime;
        private final String lastIndexName;

        public IndexStrategyToken(String requestedTokenString) {
            IndexStrategyToken.validateIndexStrategyToken(requestedTokenString);
            String decryptedToken = PaginationStrategy.decryptStringToken(requestedTokenString);
            String[] decryptedTokenElements = decryptedToken.split(SPLIT_REGEX);
            this.lastIndexCreationTime = Long.parseLong(decryptedTokenElements[0]);
            this.lastIndexName = decryptedTokenElements[1];
        }

        public IndexStrategyToken(long creationTimeOfLastRespondedIndex, String nameOfLastRespondedIndex) {
            Objects.requireNonNull(nameOfLastRespondedIndex, "index name should be provided");
            this.lastIndexCreationTime = creationTimeOfLastRespondedIndex;
            this.lastIndexName = nameOfLastRespondedIndex;
        }

        public String generateEncryptedToken() {
            return PaginationStrategy.encryptStringToken(String.join((CharSequence)JOIN_DELIMITER, String.valueOf(this.lastIndexCreationTime), this.lastIndexName));
        }

        public static void validateIndexStrategyToken(String requestedTokenStr) {
            Objects.requireNonNull(requestedTokenStr, "requestedTokenString can not be null");
            String decryptedToken = PaginationStrategy.decryptStringToken(requestedTokenStr);
            String[] decryptedTokenElements = decryptedToken.split(SPLIT_REGEX);
            if (decryptedTokenElements.length != 2) {
                throw new OpenSearchParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
            }
            try {
                long creationTimeOfLastRespondedIndex = Long.parseLong(decryptedTokenElements[0]);
                if (creationTimeOfLastRespondedIndex <= 0L) {
                    throw new OpenSearchParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
                }
            }
            catch (NumberFormatException exception) {
                throw new OpenSearchParseException("Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].", new Object[0]);
            }
        }
    }
}

