/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexGraveyard;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.index.Index;
import org.opensearch.gateway.GatewayService;

@PublicApi(since="1.0.0")
public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;

    public ClusterChangedEvent(String source, ClusterState state, ClusterState previousState) {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(previousState, "previousState must not be null");
        this.source = source;
        this.state = state;
        this.previousState = previousState;
        this.nodesDelta = state.nodes().delta(previousState.nodes());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.routingTable() != this.previousState.routingTable();
    }

    public boolean indexRoutingTableChanged(String index) {
        Objects.requireNonNull(index, "index must not be null");
        if (!this.state.routingTable().hasIndex(index) && !this.previousState.routingTable().hasIndex(index)) {
            return false;
        }
        if (this.state.routingTable().hasIndex(index) && this.previousState.routingTable().hasIndex(index)) {
            return this.state.routingTable().index(index) != this.previousState.routingTable().index(index);
        }
        return true;
    }

    public List<String> indicesCreated() {
        if (!this.metadataChanged()) {
            return Collections.emptyList();
        }
        ArrayList<String> created = null;
        for (String index : this.state.metadata().indices().keySet()) {
            if (this.previousState.metadata().hasIndex(index)) continue;
            if (created == null) {
                created = new ArrayList<String>();
            }
            created.add(index);
        }
        return created == null ? Collections.emptyList() : created;
    }

    public List<Index> indicesDeleted() {
        if (this.previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return this.indicesDeletedFromTombstones();
        }
        return this.indicesDeletedFromClusterState();
    }

    public boolean metadataChanged() {
        return this.state.metadata() != this.previousState.metadata();
    }

    public Set<String> changedCustomMetadataSet() {
        Map<String, Metadata.Custom> previousCustoms;
        HashSet<String> result = new HashSet<String>();
        Map<String, Metadata.Custom> currentCustoms = this.state.metadata().customs();
        if (!currentCustoms.equals(previousCustoms = this.previousState.metadata().customs())) {
            for (Map.Entry<String, Metadata.Custom> currentCustomMetadata : currentCustoms.entrySet()) {
                if (previousCustoms.containsKey(currentCustomMetadata.getKey()) && currentCustomMetadata.getValue().equals(previousCustoms.get(currentCustomMetadata.getKey()))) continue;
                result.add(currentCustomMetadata.getKey());
            }
            for (Map.Entry<String, Metadata.Custom> previousCustomMetadata : previousCustoms.entrySet()) {
                if (currentCustoms.containsKey(previousCustomMetadata.getKey())) continue;
                result.add(previousCustomMetadata.getKey());
            }
        }
        return result;
    }

    public static boolean indexMetadataChanged(IndexMetadata metadata1, IndexMetadata metadata2) {
        assert (metadata1 != null && metadata2 != null);
        return metadata1 != metadata2;
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeClusterManager() {
        return this.state.nodes().isLocalNodeElectedClusterManager();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }

    public boolean isNewCluster() {
        String currClusterUUID;
        String prevClusterUUID = this.previousState.metadata().clusterUUID();
        return !prevClusterUUID.equals(currClusterUUID = this.state.metadata().clusterUUID());
    }

    private List<Index> indicesDeletedFromClusterState() {
        IndexGraveyard.IndexGraveyardDiff indexGraveyardDiff;
        List<IndexGraveyard.Tombstone> added;
        IndexGraveyard previousGraveyard;
        if (!this.metadataChanged() || this.isNewCluster()) {
            return Collections.emptyList();
        }
        HashSet<Index> deleted = null;
        Metadata previousMetadata = this.previousState.metadata();
        Metadata currentMetadata = this.state.metadata();
        for (IndexMetadata index : previousMetadata.indices().values()) {
            IndexMetadata current = currentMetadata.index(index.getIndex());
            if (current != null) continue;
            if (deleted == null) {
                deleted = new HashSet<Index>();
            }
            deleted.add(index.getIndex());
        }
        IndexGraveyard currentGraveyard = currentMetadata.indexGraveyard();
        if (currentGraveyard != (previousGraveyard = previousMetadata.indexGraveyard()) && !(added = (indexGraveyardDiff = (IndexGraveyard.IndexGraveyardDiff)currentGraveyard.diff(previousGraveyard)).getAdded()).isEmpty()) {
            if (deleted == null) {
                deleted = new HashSet();
            }
            for (IndexGraveyard.Tombstone tombstone : added) {
                deleted.add(tombstone.getIndex());
            }
        }
        return deleted == null ? Collections.emptyList() : new ArrayList(deleted);
    }

    private List<Index> indicesDeletedFromTombstones() {
        List<IndexGraveyard.Tombstone> tombstones = this.state.metadata().indexGraveyard().getTombstones();
        return tombstones.stream().map(IndexGraveyard.Tombstone::getIndex).collect(Collectors.toList());
    }
}

