/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.Instant;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.wlm.MutableWorkloadGroupFragment;
import org.opensearch.wlm.ResourceType;

@PublicApi(since="2.18.0")
public class WorkloadGroup
extends AbstractDiffable<WorkloadGroup>
implements ToXContentObject {
    public static final String _ID_STRING = "_id";
    public static final String NAME_STRING = "name";
    public static final String UPDATED_AT_STRING = "updated_at";
    private static final int MAX_CHARS_ALLOWED_IN_NAME = 50;
    private final String name;
    private final String _id;
    private final long updatedAtInMillis;
    private final MutableWorkloadGroupFragment mutableWorkloadGroupFragment;

    public WorkloadGroup(String name, MutableWorkloadGroupFragment mutableWorkloadGroupFragment) {
        this(name, UUIDs.randomBase64UUID(), mutableWorkloadGroupFragment, Instant.now().getMillis());
    }

    public WorkloadGroup(String name, String _id, MutableWorkloadGroupFragment mutableWorkloadGroupFragment, long updatedAt) {
        Objects.requireNonNull(name, "WorkloadGroup.name can't be null");
        Objects.requireNonNull(mutableWorkloadGroupFragment.getResourceLimits(), "WorkloadGroup.resourceLimits can't be null");
        Objects.requireNonNull(mutableWorkloadGroupFragment.getResiliencyMode(), "WorkloadGroup.resiliencyMode can't be null");
        Objects.requireNonNull(_id, "WorkloadGroup._id can't be null");
        WorkloadGroup.validateName(name);
        if (mutableWorkloadGroupFragment.getResourceLimits().isEmpty()) {
            throw new IllegalArgumentException("WorkloadGroup.resourceLimits should at least have 1 resource limit");
        }
        if (!WorkloadGroup.isValid(updatedAt)) {
            throw new IllegalArgumentException("WorkloadGroup.updatedAtInMillis is not a valid epoch");
        }
        this.name = name;
        this._id = _id;
        this.mutableWorkloadGroupFragment = mutableWorkloadGroupFragment;
        this.updatedAtInMillis = updatedAt;
    }

    public static boolean isValid(long updatedAt) {
        long minValidTimestamp = Instant.ofEpochMilli((long)0L).getMillis();
        long currentSeconds = Instant.now().getMillis();
        return minValidTimestamp <= updatedAt && updatedAt <= currentSeconds;
    }

    public WorkloadGroup(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), new MutableWorkloadGroupFragment(in), in.readLong());
    }

    public static WorkloadGroup updateExistingWorkloadGroup(WorkloadGroup existingGroup, MutableWorkloadGroupFragment mutableWorkloadGroupFragment) {
        HashMap<ResourceType, Double> updatedResourceLimits = new HashMap<ResourceType, Double>(existingGroup.getResourceLimits());
        Map<ResourceType, Double> mutableFragmentResourceLimits = mutableWorkloadGroupFragment.getResourceLimits();
        if (mutableFragmentResourceLimits != null && !mutableFragmentResourceLimits.isEmpty()) {
            updatedResourceLimits.putAll(mutableFragmentResourceLimits);
        }
        MutableWorkloadGroupFragment.ResiliencyMode mode = Optional.ofNullable(mutableWorkloadGroupFragment.getResiliencyMode()).orElse(existingGroup.getResiliencyMode());
        return new WorkloadGroup(existingGroup.getName(), existingGroup.get_id(), new MutableWorkloadGroupFragment(mode, updatedResourceLimits), Instant.now().getMillis());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this._id);
        this.mutableWorkloadGroupFragment.writeTo(out);
        out.writeLong(this.updatedAtInMillis);
    }

    public static void validateName(String name) {
        if (name == null || name.isEmpty() || name.length() > 50) {
            throw new IllegalArgumentException("WorkloadGroup.name shouldn't be null, empty or more than 50 chars long");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_ID_STRING, this._id);
        builder.field(NAME_STRING, this.name);
        for (String fieldName : MutableWorkloadGroupFragment.acceptedFieldNames) {
            this.mutableWorkloadGroupFragment.writeField(builder, fieldName);
        }
        builder.field(UPDATED_AT_STRING, this.updatedAtInMillis);
        builder.endObject();
        return builder;
    }

    public static WorkloadGroup fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser).build();
    }

    public static Diff<WorkloadGroup> readDiff(StreamInput in) throws IOException {
        return WorkloadGroup.readDiffFrom(WorkloadGroup::new, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadGroup that = (WorkloadGroup)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.mutableWorkloadGroupFragment, that.mutableWorkloadGroupFragment) && Objects.equals(this._id, that._id) && this.updatedAtInMillis == that.updatedAtInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.mutableWorkloadGroupFragment, this.updatedAtInMillis, this._id);
    }

    public String getName() {
        return this.name;
    }

    public MutableWorkloadGroupFragment getMutableWorkloadGroupFragment() {
        return this.mutableWorkloadGroupFragment;
    }

    public MutableWorkloadGroupFragment.ResiliencyMode getResiliencyMode() {
        return this.getMutableWorkloadGroupFragment().getResiliencyMode();
    }

    public Map<ResourceType, Double> getResourceLimits() {
        return this.getMutableWorkloadGroupFragment().getResourceLimits();
    }

    public String get_id() {
        return this._id;
    }

    public long getUpdatedAtInMillis() {
        return this.updatedAtInMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    @ExperimentalApi
    public static class Builder {
        private String name;
        private String _id;
        private MutableWorkloadGroupFragment mutableWorkloadGroupFragment;
        private long updatedAt;

        private Builder() {
        }

        public static Builder fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            Builder builder = WorkloadGroup.builder();
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected START_OBJECT token but found [" + parser.currentName() + "]");
            }
            String fieldName = "";
            MutableWorkloadGroupFragment mutableWorkloadGroupFragment1 = new MutableWorkloadGroupFragment();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (fieldName.equals(WorkloadGroup._ID_STRING)) {
                        builder._id(parser.text());
                        continue;
                    }
                    if (fieldName.equals(WorkloadGroup.NAME_STRING)) {
                        builder.name(parser.text());
                        continue;
                    }
                    if (MutableWorkloadGroupFragment.shouldParse(fieldName)) {
                        mutableWorkloadGroupFragment1.parseField(parser, fieldName);
                        continue;
                    }
                    if (fieldName.equals(WorkloadGroup.UPDATED_AT_STRING)) {
                        builder.updatedAt(parser.longValue());
                        continue;
                    }
                    throw new IllegalArgumentException(fieldName + " is not a valid field in WorkloadGroup");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (!MutableWorkloadGroupFragment.shouldParse(fieldName)) {
                    throw new IllegalArgumentException(fieldName + " is not a valid object in WorkloadGroup");
                }
                mutableWorkloadGroupFragment1.parseField(parser, fieldName);
            }
            return builder.mutableWorkloadGroupFragment(mutableWorkloadGroupFragment1);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder _id(String _id) {
            this._id = _id;
            return this;
        }

        public Builder mutableWorkloadGroupFragment(MutableWorkloadGroupFragment mutableWorkloadGroupFragment) {
            this.mutableWorkloadGroupFragment = mutableWorkloadGroupFragment;
            return this;
        }

        public Builder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public WorkloadGroup build() {
            return new WorkloadGroup(this.name, this._id, this.mutableWorkloadGroupFragment, this.updatedAt);
        }

        public MutableWorkloadGroupFragment getMutableWorkloadGroupFragment() {
            return this.mutableWorkloadGroupFragment;
        }
    }
}

