/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.get;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class GetStats
implements Writeable,
ToXContentFragment {
    private long existsCount;
    private long existsTimeInMillis;
    private long missingCount;
    private long missingTimeInMillis;
    private long current;

    public GetStats() {
    }

    public GetStats(StreamInput in) throws IOException {
        this.existsCount = in.readVLong();
        this.existsTimeInMillis = in.readVLong();
        this.missingCount = in.readVLong();
        this.missingTimeInMillis = in.readVLong();
        this.current = in.readVLong();
    }

    public GetStats(long existsCount, long existsTimeInMillis, long missingCount, long missingTimeInMillis, long current) {
        this.existsCount = existsCount;
        this.existsTimeInMillis = existsTimeInMillis;
        this.missingCount = missingCount;
        this.missingTimeInMillis = missingTimeInMillis;
        this.current = current;
    }

    public void add(GetStats stats) {
        if (stats == null) {
            return;
        }
        this.current += stats.current;
        this.addTotals(stats);
    }

    public void addTotals(GetStats stats) {
        if (stats == null) {
            return;
        }
        this.existsCount += stats.existsCount;
        this.existsTimeInMillis += stats.existsTimeInMillis;
        this.missingCount += stats.missingCount;
        this.missingTimeInMillis += stats.missingTimeInMillis;
        this.current += stats.current;
    }

    public long getCount() {
        return this.existsCount + this.missingCount;
    }

    public long getTimeInMillis() {
        return this.existsTimeInMillis + this.missingTimeInMillis;
    }

    public TimeValue getTime() {
        return new TimeValue(this.getTimeInMillis());
    }

    public long getExistsCount() {
        return this.existsCount;
    }

    public long getExistsTimeInMillis() {
        return this.existsTimeInMillis;
    }

    public TimeValue getExistsTime() {
        return new TimeValue(this.existsTimeInMillis);
    }

    public long getMissingCount() {
        return this.missingCount;
    }

    public long getMissingTimeInMillis() {
        return this.missingTimeInMillis;
    }

    public TimeValue getMissingTime() {
        return new TimeValue(this.missingTimeInMillis);
    }

    public long current() {
        return this.current;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("get");
        builder.field("total", this.getCount());
        builder.field("getTime", Objects.toString(this.getTime()));
        builder.humanReadableField("time_in_millis", "time", (Object)this.getTime());
        builder.field("exists_total", this.existsCount);
        builder.humanReadableField("exists_time_in_millis", "exists_time", (Object)this.getExistsTime());
        builder.field("missing_total", this.missingCount);
        builder.humanReadableField("missing_time_in_millis", "missing_time", (Object)this.getMissingTime());
        builder.field("current", this.current);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.existsCount);
        out.writeVLong(this.existsTimeInMillis);
        out.writeVLong(this.missingCount);
        out.writeVLong(this.missingTimeInMillis);
        out.writeVLong(this.current);
    }

    static final class Fields {
        static final String GET = "get";
        static final String TOTAL = "total";
        @Deprecated(forRemoval=true)
        static final String GET_TIME = "getTime";
        static final String TIME = "time";
        static final String TIME_IN_MILLIS = "time_in_millis";
        static final String EXISTS_TOTAL = "exists_total";
        static final String EXISTS_TIME = "exists_time";
        static final String EXISTS_TIME_IN_MILLIS = "exists_time_in_millis";
        static final String MISSING_TOTAL = "missing_total";
        static final String MISSING_TIME = "missing_time";
        static final String MISSING_TIME_IN_MILLIS = "missing_time_in_millis";
        static final String CURRENT = "current";

        Fields() {
        }
    }
}

