/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CombinedFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.search.QueryParserHelper;

public class CombinedFieldsQueryBuilder
extends AbstractQueryBuilder<CombinedFieldsQueryBuilder> {
    public static final String NAME = "combined_fields";
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private Object queryValue;
    private Map<String, Float> fieldToWeight;
    private Operator operator = Operator.OR;
    private String minimumShouldMatch;
    private static final ConstructingObjectParser<CombinedFieldsQueryBuilder, Void> XCONTENT_PARSER = new ConstructingObjectParser("combined_fields", a -> new CombinedFieldsQueryBuilder(a[0], new String[0]));

    public CombinedFieldsQueryBuilder(Object value, String ... fields) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires query value", NAME));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires field list", NAME));
        }
        this.queryValue = value;
        this.fieldToWeight = QueryParserHelper.parseFieldsAndWeights(Arrays.asList(fields));
    }

    public CombinedFieldsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryValue = in.readGenericValue();
        int numFields = in.readVInt();
        this.fieldToWeight = new HashMap<String, Float>();
        for (int i = 0; i < numFields; ++i) {
            String field = in.readString();
            float weight = in.readFloat();
            this.fieldToWeight.put(field, Float.valueOf(weight));
        }
        this.operator = Operator.readFromStream(in);
        this.minimumShouldMatch = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.queryValue);
        out.writeVInt(this.fieldToWeight.size());
        for (Map.Entry<String, Float> fieldEntry : this.fieldToWeight.entrySet()) {
            out.writeString(fieldEntry.getKey());
            out.writeFloat(fieldEntry.getValue().floatValue());
        }
        this.operator.writeTo(out);
        out.writeOptionalString(this.minimumShouldMatch);
    }

    public Object queryValue() {
        return this.queryValue;
    }

    public Map<String, Float> fieldToWeight() {
        return this.fieldToWeight;
    }

    public Operator operator() {
        return this.operator;
    }

    public CombinedFieldsQueryBuilder operator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public CombinedFieldsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryValue);
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldToWeight.entrySet()) {
            builder.value(String.format(Locale.ROOT, "%s^%s", fieldEntry.getKey(), fieldEntry.getValue()));
        }
        builder.endArray();
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static CombinedFieldsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return (CombinedFieldsQueryBuilder)XCONTENT_PARSER.parse(parser, null);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Map<String, Float> mappedFields = QueryParserHelper.resolveMappingFields(context, this.fieldToWeight);
        if (mappedFields.isEmpty()) {
            return Queries.newUnmappedFieldsQuery(this.fieldToWeight.keySet());
        }
        List<MappedFieldType> fieldTypes = this.extractAndValidateMappedFieldTypes(context, mappedFields);
        Analyzer sharedAnalyzer = this.validateAndGetSharedAnalyzer(fieldTypes);
        return this.buildQuery(mappedFields, sharedAnalyzer);
    }

    private List<MappedFieldType> extractAndValidateMappedFieldTypes(QueryShardContext context, Map<String, Float> mappedFields) {
        ArrayList<MappedFieldType> fields = new ArrayList<MappedFieldType>();
        for (Map.Entry<String, Float> entry : mappedFields.entrySet()) {
            String name = entry.getKey();
            MappedFieldType fieldType = context.getFieldType(name);
            if (fieldType == null) continue;
            this.validateFieldType(fieldType);
            fields.add(fieldType);
        }
        return fields;
    }

    private void validateFieldType(MappedFieldType fieldType) {
        if (!fieldType.familyTypeName().equals("text")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field [%s] of type [%s] does not support [%s] queries", fieldType.name(), fieldType.typeName(), NAME));
        }
    }

    private Analyzer validateAndGetSharedAnalyzer(List<MappedFieldType> fieldTypes) {
        NamedAnalyzer sharedAnalyzer = null;
        for (MappedFieldType fieldType : fieldTypes) {
            NamedAnalyzer analyzer = fieldType.getTextSearchInfo().getSearchAnalyzer();
            if (sharedAnalyzer != null && !((Object)((Object)analyzer)).equals((Object)sharedAnalyzer)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "All fields in [%s] query must have the same search analyzer", NAME));
            }
            sharedAnalyzer = analyzer;
        }
        return sharedAnalyzer;
    }

    private Query buildQuery(Map<String, Float> mappedFieldToWeight, Analyzer sharedAnalyzer) {
        assert (!mappedFieldToWeight.isEmpty());
        Builder builder = new Builder(mappedFieldToWeight, sharedAnalyzer, this.operator, this.minimumShouldMatch);
        String placeholderFieldName = mappedFieldToWeight.keySet().iterator().next();
        Query query = builder.createBooleanQuery(placeholderFieldName, this.queryValue.toString(), this.operator.toBooleanClauseOccur());
        return query == null ? this.createZeroTermsQuery() : Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
    }

    private Query createZeroTermsQuery() {
        return Queries.newMatchNoDocsQuery("Matching no documents because no terms present");
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.queryValue, this.fieldToWeight, this.operator, this.minimumShouldMatch});
    }

    @Override
    protected boolean doEquals(CombinedFieldsQueryBuilder other) {
        return Objects.equals(this.queryValue, other.queryValue) && Objects.equals(this.fieldToWeight, other.fieldToWeight) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch);
    }

    static {
        XCONTENT_PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        XCONTENT_PARSER.declareStringArray((builder, values) -> {
            Map<String, Float> fieldToWeight = QueryParserHelper.parseFieldsAndWeights(values);
            builder.fieldToWeight = fieldToWeight;
        }, FIELDS_FIELD);
        XCONTENT_PARSER.declareString(CombinedFieldsQueryBuilder::operator, Operator::fromString, OPERATOR_FIELD);
        XCONTENT_PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
        XCONTENT_PARSER.declareString(AbstractQueryBuilder::queryName, NAME_FIELD);
        XCONTENT_PARSER.declareField(CombinedFieldsQueryBuilder::minimumShouldMatch, (p, c) -> p.textOrNull(), MINIMUM_SHOULD_MATCH_FIELD, ObjectParser.ValueType.VALUE);
    }

    private static class Builder
    extends QueryBuilder {
        private final Map<String, Float> mappedFieldToWeight;
        private final Operator operator;
        private final String minimumShouldMatch;

        Builder(Map<String, Float> mappedFieldToWeight, Analyzer analyzer, Operator operator, String minimumShouldMatch) {
            super(analyzer);
            this.mappedFieldToWeight = mappedFieldToWeight;
            this.operator = operator;
            this.minimumShouldMatch = minimumShouldMatch;
        }

        public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
            throw new IllegalArgumentException("[combined_fields] queries don't support phrases");
        }

        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            throw new IllegalArgumentException("[combined_fields] queries don't support phrases");
        }

        protected Query newSynonymQuery(String fieldPlaceholder, QueryBuilder.TermAndBoost[] terms) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            BooleanClause.Occur occur = this.operator.toBooleanClauseOccur();
            for (QueryBuilder.TermAndBoost termAndBoost : terms) {
                BytesRef term = termAndBoost.term();
                CombinedFieldQuery.Builder combinedFieldBuilder = new CombinedFieldQuery.Builder(term);
                for (Map.Entry<String, Float> entry : this.mappedFieldToWeight.entrySet()) {
                    combinedFieldBuilder.addField(entry.getKey(), entry.getValue().floatValue());
                }
                builder.add((Query)combinedFieldBuilder.build(), occur);
            }
            return builder.build();
        }

        protected Query newTermQuery(Term term, float boost) {
            QueryBuilder.TermAndBoost termAndBoost = new QueryBuilder.TermAndBoost(term.bytes(), boost);
            return this.newSynonymQuery("", new QueryBuilder.TermAndBoost[]{termAndBoost});
        }
    }
}

