/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.listener.FileTransferListener;

public class FileTransferTracker
implements FileTransferListener {
    private final ConcurrentHashMap<String, TransferState> fileTransferTracker;
    private final ShardId shardId;
    private final RemoteTranslogTransferTracker remoteTranslogTransferTracker;
    private Map<String, Long> bytesForTlogCkpFileToUpload;
    private long fileTransferStartTime = -1L;
    private final Logger logger;

    public FileTransferTracker(ShardId shardId, RemoteTranslogTransferTracker remoteTranslogTransferTracker) {
        this.shardId = shardId;
        this.fileTransferTracker = new ConcurrentHashMap();
        this.remoteTranslogTransferTracker = remoteTranslogTransferTracker;
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
    }

    void recordFileTransferStartTime(long uploadStartTime) {
        if (this.fileTransferStartTime == -1L) {
            this.fileTransferStartTime = uploadStartTime;
        }
    }

    void recordBytesForFiles(Set<FileSnapshot.TransferFileSnapshot> toUpload) {
        this.bytesForTlogCkpFileToUpload = new HashMap<String, Long>();
        toUpload.forEach(file -> {
            try {
                this.bytesForTlogCkpFileToUpload.put(file.getName(), file.getContentLength());
            }
            catch (IOException ignored) {
                this.bytesForTlogCkpFileToUpload.put(file.getName(), 0L);
            }
        });
    }

    long getTotalBytesToUpload() {
        return this.bytesForTlogCkpFileToUpload.values().stream().reduce(0L, Long::sum);
    }

    @Override
    public void onSuccess(FileSnapshot.TransferFileSnapshot fileSnapshot) {
        try {
            long durationInMillis = (System.nanoTime() - this.fileTransferStartTime) / 1000000L;
            this.remoteTranslogTransferTracker.addUploadTimeInMillis(durationInMillis);
            this.remoteTranslogTransferTracker.addUploadBytesSucceeded(this.bytesForTlogCkpFileToUpload.get(fileSnapshot.getName()));
        }
        catch (Exception ex) {
            this.logger.error("Failure to update translog upload success stats", (Throwable)ex);
        }
        this.add(fileSnapshot.getName(), TransferState.SUCCESS);
    }

    void add(String file, boolean success) {
        TransferState targetState = success ? TransferState.SUCCESS : TransferState.FAILED;
        this.add(file, targetState);
    }

    private void add(String file, TransferState targetState) {
        this.fileTransferTracker.compute(file, (k, v) -> {
            if (v == null || v.validateNextState(targetState)) {
                return targetState;
            }
            throw new IllegalStateException("Unexpected transfer state " + String.valueOf(v) + "while setting target to" + String.valueOf((Object)targetState));
        });
    }

    @Override
    public void onFailure(FileSnapshot.TransferFileSnapshot fileSnapshot, Exception e) {
        long durationInMillis = (System.nanoTime() - this.fileTransferStartTime) / 1000000L;
        this.remoteTranslogTransferTracker.addUploadTimeInMillis(durationInMillis);
        this.remoteTranslogTransferTracker.addUploadBytesFailed(this.bytesForTlogCkpFileToUpload.get(fileSnapshot.getName()));
        this.add(fileSnapshot.getName(), TransferState.FAILED);
    }

    public void delete(List<String> names) {
        for (String name : names) {
            this.fileTransferTracker.remove(name);
        }
    }

    public boolean uploaded(String file) {
        return this.fileTransferTracker.get(file) == TransferState.SUCCESS;
    }

    public Set<FileSnapshot.TransferFileSnapshot> exclusionFilter(Set<FileSnapshot.TransferFileSnapshot> original) {
        return original.stream().filter(fileSnapshot -> this.fileTransferTracker.get(fileSnapshot.getName()) != TransferState.SUCCESS).collect(Collectors.toSet());
    }

    public Set<String> allUploaded() {
        HashSet<String> successFileTransferTracker = new HashSet<String>();
        this.fileTransferTracker.forEach((k, v) -> {
            if (v == TransferState.SUCCESS) {
                successFileTransferTracker.add((String)k);
            }
        });
        return successFileTransferTracker;
    }

    private static enum TransferState {
        SUCCESS,
        FAILED;


        public boolean validateNextState(TransferState target) {
            switch (this.ordinal()) {
                case 1: {
                    return true;
                }
                case 0: {
                    return Objects.equals((Object)SUCCESS, (Object)target);
                }
            }
            return false;
        }
    }
}

