/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InvalidAggregationPathException;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalMultiBucketAggregation<A extends InternalMultiBucketAggregation, B extends InternalBucket>
extends InternalAggregation
implements MultiBucketsAggregation {
    public InternalMultiBucketAggregation(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected InternalMultiBucketAggregation(StreamInput in) throws IOException {
        super(in);
    }

    public abstract A create(List<B> var1);

    public abstract B createBucket(InternalAggregations var1, B var2);

    protected abstract B reduceBucket(List<B> var1, InternalAggregation.ReduceContext var2);

    public abstract List<B> getBuckets();

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        return InternalMultiBucketAggregation.resolvePropertyFromPath(path, this.getBuckets(), this.getName());
    }

    /*
     * WARNING - void declaration
     */
    static Object resolvePropertyFromPath(List<String> path, List<? extends InternalBucket> buckets, String name) {
        void var5_8;
        String aggName = path.get(0);
        if (aggName.equals("_bucket_count")) {
            return buckets.size();
        }
        if (aggName.startsWith("'") && aggName.endsWith("'")) {
            for (InternalBucket internalBucket : buckets) {
                if (!internalBucket.getKeyAsString().equals(aggName.substring(1, aggName.length() - 1))) continue;
                return internalBucket.getProperty(name, path.subList(1, path.size()));
            }
            throw new InvalidAggregationPathException("Cannot find an key [" + aggName + "] in [" + name + "]");
        }
        Object[] propertyArray = new Object[buckets.size()];
        boolean bl = false;
        while (var5_8 < buckets.size()) {
            propertyArray[var5_8] = buckets.get((int)var5_8).getProperty(name, path);
            ++var5_8;
        }
        return propertyArray;
    }

    public static int countInnerBucket(InternalBucket bucket) {
        int count = 0;
        for (Aggregation agg : bucket.getAggregations().asList()) {
            count += InternalMultiBucketAggregation.countInnerBucket(agg);
        }
        return count;
    }

    public static int countInnerBucket(Aggregation agg) {
        int size;
        block4: {
            block3: {
                size = 0;
                if (!(agg instanceof MultiBucketsAggregation)) break block3;
                MultiBucketsAggregation multi = (MultiBucketsAggregation)agg;
                for (MultiBucketsAggregation.Bucket bucket : multi.getBuckets()) {
                    ++size;
                    for (Aggregation bucketAgg : bucket.getAggregations().asList()) {
                        size += InternalMultiBucketAggregation.countInnerBucket(bucketAgg);
                    }
                }
                break block4;
            }
            if (!(agg instanceof SingleBucketAggregation)) break block4;
            SingleBucketAggregation single = (SingleBucketAggregation)agg;
            for (Aggregation aggregation : single.getAggregations().asList()) {
                size += InternalMultiBucketAggregation.countInnerBucket(aggregation);
            }
        }
        return size;
    }

    @Override
    public final InternalAggregation reducePipelines(InternalAggregation reducedAggs, InternalAggregation.ReduceContext reduceContext, PipelineAggregator.PipelineTree pipelineTree) {
        assert (reduceContext.isFinalReduce());
        InternalMultiBucketAggregation<A, B> reduced = this;
        if (pipelineTree.hasSubTrees()) {
            List<B> materializedBuckets = this.reducePipelineBuckets(reduceContext, pipelineTree);
            reduced = this.create(materializedBuckets);
        }
        return super.reducePipelines(reduced, reduceContext, pipelineTree);
    }

    @Override
    public InternalAggregation copyWithRewritenBuckets(Function<InternalAggregations, InternalAggregations> rewriter) {
        boolean modified = false;
        ArrayList<InternalBucket> newBuckets = new ArrayList<InternalBucket>();
        for (InternalBucket bucket : this.getBuckets()) {
            InternalAggregations rewritten = rewriter.apply((InternalAggregations)bucket.getAggregations());
            if (rewritten == null) {
                newBuckets.add(bucket);
                continue;
            }
            modified = true;
            InternalBucket newBucket = this.createBucket(rewritten, bucket);
            newBuckets.add(newBucket);
        }
        return modified ? this.create(newBuckets) : this;
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public void forEachBucket(Consumer<InternalAggregations> consumer) {
        for (InternalBucket bucket : this.getBuckets()) {
            consumer.accept((InternalAggregations)bucket.getAggregations());
        }
    }

    private List<B> reducePipelineBuckets(InternalAggregation.ReduceContext reduceContext, PipelineAggregator.PipelineTree pipelineTree) {
        ArrayList<InternalBucket> reducedBuckets = new ArrayList<InternalBucket>();
        for (InternalBucket bucket : this.getBuckets()) {
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
            for (Aggregation agg : bucket.getAggregations()) {
                PipelineAggregator.PipelineTree subTree = pipelineTree.subTree(agg.getName());
                aggs.add(((InternalAggregation)agg).reducePipelines((InternalAggregation)agg, reduceContext, subTree));
            }
            reducedBuckets.add(this.createBucket(InternalAggregations.from(aggs), bucket));
        }
        return reducedBuckets;
    }

    public static abstract class InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Writeable {
        public Object getProperty(String containingAggName, List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            Aggregations aggregations = this.getAggregations();
            String aggName = path.get(0);
            if (aggName.equals("_count")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_count must be the last element in the path");
                }
                return this.getDocCount();
            }
            if (aggName.equals("_key")) {
                if (path.size() > 1) {
                    throw new InvalidAggregationPathException("_key must be the last element in the path");
                }
                return this.getKey();
            }
            InternalAggregation aggregation = (InternalAggregation)aggregations.get(aggName);
            if (aggregation == null) {
                throw new InvalidAggregationPathException("Cannot find an aggregation named [" + aggName + "] in [" + containingAggName + "]");
            }
            return aggregation.getProperty(path.subList(1, path.size()));
        }
    }
}

