/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.AggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.Helper;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.internal.SearchContext;

public final class FilterRewriteOptimizationContext {
    private static final Logger logger = LogManager.getLogger((String)Helper.loggerName);
    private final boolean canOptimize;
    private boolean preparedAtShardLevel = false;
    private final AggregatorBridge aggregatorBridge;
    private String shardId;
    private Ranges ranges;
    private boolean hasSubAgg;
    private final AtomicInteger leafNodeVisited = new AtomicInteger();
    private final AtomicInteger innerNodeVisited = new AtomicInteger();
    private final AtomicInteger segments = new AtomicInteger();
    private final AtomicInteger optimizedSegments = new AtomicInteger();
    private int segmentThreshold = 0;

    public FilterRewriteOptimizationContext(AggregatorBridge aggregatorBridge, Object parent, int subAggLength, SearchContext context) throws IOException {
        this.aggregatorBridge = aggregatorBridge;
        this.canOptimize = this.canOptimize(parent, subAggLength, context);
    }

    private boolean canOptimize(Object parent, int subAggLength, SearchContext context) throws IOException {
        if (context.maxAggRewriteFilters() == 0) {
            return false;
        }
        if (parent != null) {
            return false;
        }
        this.hasSubAgg = subAggLength > 0;
        boolean canOptimize = this.aggregatorBridge.canOptimize();
        if (canOptimize) {
            this.aggregatorBridge.setRangesConsumer(this::setRanges);
            this.shardId = context.indexShard().shardId().toString();
            assert (this.ranges == null) : "Ranges should only be built once at shard level, but they are already built";
            this.aggregatorBridge.prepare();
            if (this.ranges != null) {
                this.preparedAtShardLevel = true;
            }
        }
        logger.debug("Fast filter rewriteable: {} for shard {}", (Object)canOptimize, (Object)this.shardId);
        this.segmentThreshold = context.filterRewriteSegmentThreshold();
        return canOptimize;
    }

    void setRanges(Ranges ranges) {
        this.ranges = ranges;
    }

    public boolean tryOptimize(LeafReaderContext leafCtx, BiConsumer<Long, Long> incrementDocCount, boolean segmentMatchAll, BucketCollector collectableSubAggregators) throws IOException {
        this.segments.incrementAndGet();
        if (!this.canOptimize) {
            return false;
        }
        if (leafCtx.reader().hasDeletions()) {
            return false;
        }
        PointValues values = leafCtx.reader().getPointValues(this.aggregatorBridge.fieldType.name());
        if (values == null) {
            return false;
        }
        if ((long)values.getDocCount() != values.size()) {
            return false;
        }
        NumericDocValues docCountValues = DocValues.getNumeric((LeafReader)leafCtx.reader(), (String)"_doc_count");
        if (docCountValues.nextDoc() != Integer.MAX_VALUE) {
            logger.debug("Shard {} segment {} has at least one document with _doc_count field, skip fast filter optimization", (Object)this.shardId, (Object)leafCtx.ord);
            return false;
        }
        Ranges ranges = this.getRanges(leafCtx, segmentMatchAll);
        if (ranges == null) {
            return false;
        }
        if (this.hasSubAgg && this.segmentThreshold > leafCtx.reader().maxDoc() / ranges.getSize()) {
            return false;
        }
        SubAggCollectorParam subAggCollectorParam = this.hasSubAgg ? new SubAggCollectorParam(collectableSubAggregators, leafCtx) : null;
        try {
            OptimizeResult optimizeResult = this.aggregatorBridge.tryOptimize(values, incrementDocCount, ranges, subAggCollectorParam);
            this.consumeDebugInfo(optimizeResult);
        }
        catch (AbortFilterRewriteOptimizationException e) {
            logger.error("Abort filter rewrite optimization, fall back to default path");
            return false;
        }
        this.optimizedSegments.incrementAndGet();
        logger.debug("Fast filter optimization applied to shard {} segment {}", (Object)this.shardId, (Object)leafCtx.ord);
        logger.debug("Crossed leaf nodes: {}, inner nodes: {}", (Object)this.leafNodeVisited, (Object)this.innerNodeVisited);
        return true;
    }

    Ranges getRanges(LeafReaderContext leafCtx, boolean segmentMatchAll) {
        if (!this.preparedAtShardLevel) {
            try {
                return this.getRangesFromSegment(leafCtx, segmentMatchAll);
            }
            catch (IOException e) {
                logger.warn("Failed to build ranges from segment.", (Throwable)e);
                return null;
            }
        }
        return this.ranges;
    }

    private Ranges getRangesFromSegment(LeafReaderContext leafCtx, boolean segmentMatchAll) throws IOException {
        if (!segmentMatchAll) {
            return null;
        }
        logger.debug("Shard {} segment {} functionally match all documents. Build the fast filter", (Object)this.shardId, (Object)leafCtx.ord);
        return this.aggregatorBridge.tryBuildRangesFromSegment(leafCtx);
    }

    void consumeDebugInfo(OptimizeResult debug) {
        this.leafNodeVisited.addAndGet(debug.leafNodeVisited.get());
        this.innerNodeVisited.addAndGet(debug.innerNodeVisited.get());
    }

    public void populateDebugInfo(BiConsumer<String, Object> add) {
        if (this.optimizedSegments.get() > 0) {
            add.accept("optimized_segments", this.optimizedSegments.get());
            add.accept("unoptimized_segments", this.segments.get() - this.optimizedSegments.get());
            add.accept("leaf_visited", this.leafNodeVisited.get());
            add.accept("inner_visited", this.innerNodeVisited.get());
        }
    }

    public record SubAggCollectorParam(BucketCollector collectableSubAggregators, LeafReaderContext leafCtx) {
    }

    public static class OptimizeResult {
        private final AtomicInteger leafNodeVisited = new AtomicInteger();
        private final AtomicInteger innerNodeVisited = new AtomicInteger();
        public DocIdSetBuilder[] builders = new DocIdSetBuilder[0];

        public void visitLeaf() {
            this.leafNodeVisited.incrementAndGet();
        }

        public void visitInner() {
            this.innerNodeVisited.incrementAndGet();
        }
    }

    static class AbortFilterRewriteOptimizationException
    extends RuntimeException {
        AbortFilterRewriteOptimizationException(String message, Exception e) {
            super(message, e);
        }
    }
}

