/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.lease.Releasable;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public class StreamStringTermsAggregator
extends AbstractStringTermsAggregator {
    private SortedSetDocValues sortedDocValuesPerBatch;
    private long valueCount;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    protected int segmentsWithSingleValuedOrds = 0;
    protected int segmentsWithMultiValuedOrds = 0;
    protected final ResultStrategy<?, ?, ?> resultStrategy;

    public StreamStringTermsAggregator(String name, AggregatorFactories factories, Function<StreamStringTermsAggregator, ResultStrategy<?, ?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.valuesSource = valuesSource;
        this.resultStrategy = resultStrategy.apply(this);
    }

    @Override
    public void doReset() {
        super.doReset();
        this.valueCount = 0L;
        this.sortedDocValuesPerBatch = null;
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        return false;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregationsBatch(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        this.sortedDocValuesPerBatch = this.valuesSource.ordinalsValues(ctx);
        this.valueCount = this.sortedDocValuesPerBatch.getValueCount();
        this.docCounts = this.docCounts == null ? this.context.bigArrays().newLongArray(this.valueCount, true) : this.context.bigArrays().grow(this.docCounts, this.valueCount);
        final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)this.sortedDocValuesPerBatch);
        if (singleValues != null) {
            ++this.segmentsWithSingleValuedOrds;
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, this.sortedDocValuesPerBatch){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!singleValues.advanceExact(doc)) {
                        return;
                    }
                    int ordinal = singleValues.ordValue();
                    StreamStringTermsAggregator.this.collectExistingBucket(sub, doc, ordinal);
                }
            });
        }
        ++this.segmentsWithMultiValuedOrds;
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, this.sortedDocValuesPerBatch){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                long ordinal;
                if (!StreamStringTermsAggregator.this.sortedDocValuesPerBatch.advanceExact(doc)) {
                    return;
                }
                int count = StreamStringTermsAggregator.this.sortedDocValuesPerBatch.docValueCount();
                while (count-- > 0 && (ordinal = StreamStringTermsAggregator.this.sortedDocValuesPerBatch.nextOrd()) != Integer.MAX_VALUE) {
                    StreamStringTermsAggregator.this.collectExistingBucket(sub, doc, ordinal);
                }
            }
        });
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("segments_with_single_valued_ords", this.segmentsWithSingleValuedOrds);
        add.accept("segments_with_multi_valued_ords", this.segmentsWithMultiValuedOrds);
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket, TB extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        InternalAggregation[] buildAggregationsBatch(long[] owningBucketOrds) throws IOException {
            LocalBucketCountThresholds localBucketCountThresholds = StreamStringTermsAggregator.this.context.asLocalBucketCountThresholds(StreamStringTermsAggregator.this.bucketCountThresholds);
            if (StreamStringTermsAggregator.this.valueCount == 0L) {
                InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    results[ordIdx] = this.buildNoValuesResult(owningBucketOrds[ordIdx]);
                }
                return results;
            }
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOwningOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCount = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                StreamStringTermsAggregator.this.checkCancelled();
                ArrayList<B> bucketsPerOwningOrd = new ArrayList<B>();
                for (long ordinal = 0L; ordinal < StreamStringTermsAggregator.this.valueCount; ++ordinal) {
                    long docCount = StreamStringTermsAggregator.this.bucketDocCount(ordinal);
                    if (StreamStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L && docCount <= 0L || docCount < localBucketCountThresholds.getMinDocCount()) continue;
                    B finalBucket = this.buildFinalBucket(ordinal, docCount);
                    bucketsPerOwningOrd.add(finalBucket);
                }
                topBucketsPerOwningOrd[ordIdx] = this.buildBuckets(bucketsPerOwningOrd.size());
                for (int i = 0; i < topBucketsPerOwningOrd[ordIdx].length; ++i) {
                    topBucketsPerOwningOrd[ordIdx][i] = (InternalMultiBucketAggregation.InternalBucket)bucketsPerOwningOrd.get(i);
                }
            }
            this.buildSubAggs(topBucketsPerOwningOrd);
            InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                results[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCount[ordIdx], topBucketsPerOwningOrd[ordIdx]);
            }
            return results;
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract R buildNoValuesResult(long var1);

        abstract B buildFinalBucket(long var1, long var3) throws IOException;
    }

    class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket, GlobalOrdinalsStringTermsAggregator.OrdBucket> {
        StandardTermsResults() {
        }

        @Override
        String describe() {
            return "streaming_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        StringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new StringTerms.Bucket[size][];
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        void buildSubAggs(StringTerms.Bucket[][] topBucketsPerOrd) throws IOException {
            StreamStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamStringTermsAggregator.this.order;
            }
            return new StringTerms(StreamStringTermsAggregator.this.name, reduceOrder, StreamStringTermsAggregator.this.order, StreamStringTermsAggregator.this.metadata(), StreamStringTermsAggregator.this.format, StreamStringTermsAggregator.this.bucketCountThresholds.getShardSize(), StreamStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), 0L, StreamStringTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        StringTerms buildEmptyResult() {
            return StreamStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        @Override
        StringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return this.buildEmptyResult();
        }

        @Override
        StringTerms.Bucket buildFinalBucket(long ordinal, long docCount) throws IOException {
            BytesRef term = BytesRef.deepCopyOf((BytesRef)StreamStringTermsAggregator.this.sortedDocValuesPerBatch.lookupOrd(ordinal));
            StringTerms.Bucket result = new StringTerms.Bucket(term, docCount, null, StreamStringTermsAggregator.this.showTermDocCountError, 0L, StreamStringTermsAggregator.this.format);
            result.bucketOrd = ordinal;
            result.docCountError = 0L;
            return result;
        }

        public void close() {
        }
    }
}

