/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.WeightedAvgAggregator;
import org.opensearch.search.aggregations.support.MultiValuesSource;
import org.opensearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, DocValueFormat format, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, format, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs, this.queryShardContext);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, searchContext, parent, metadata);
    }

    @Override
    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName())).valueSourceType().typeName();
    }

    @Override
    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

