/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.stream;

import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public enum StreamErrorCode {
    OK(0),
    CANCELLED(1),
    UNKNOWN(2),
    INVALID_ARGUMENT(3),
    TIMED_OUT(4),
    NOT_FOUND(5),
    ALREADY_EXISTS(6),
    UNAUTHENTICATED(7),
    UNAUTHORIZED(8),
    RESOURCE_EXHAUSTED(9),
    UNIMPLEMENTED(10),
    INTERNAL(11),
    UNAVAILABLE(12);

    private final int code;

    private StreamErrorCode(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static StreamErrorCode fromCode(int code) {
        for (StreamErrorCode value : StreamErrorCode.values()) {
            if (value.code != code) continue;
            return value;
        }
        return UNKNOWN;
    }
}

