/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.TypeTokenFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class KeepTypesFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<String> keepTypes;
    private final KeepTypesMode includeMode;
    static final String KEEP_TYPES_KEY = "types";
    static final String KEEP_TYPES_MODE_KEY = "mode";

    KeepTypesFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List arrayKeepTypes = settings.getAsList(KEEP_TYPES_KEY, null);
        if (arrayKeepTypes == null) {
            throw new IllegalArgumentException("keep_types requires `types` to be configured");
        }
        this.includeMode = KeepTypesMode.fromString(settings.get(KEEP_TYPES_MODE_KEY, "include"));
        this.keepTypes = new HashSet<String>(arrayKeepTypes);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new TypeTokenFilter(tokenStream, this.keepTypes, this.includeMode == KeepTypesMode.INCLUDE);
    }

    static enum KeepTypesMode {
        INCLUDE,
        EXCLUDE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static KeepTypesMode fromString(String modeString) {
            String lc = modeString.toLowerCase(Locale.ROOT);
            if (lc.equals("include")) {
                return INCLUDE;
            }
            if (lc.equals("exclude")) {
                return EXCLUDE;
            }
            throw new IllegalArgumentException("`keep_types` tokenfilter mode can only be [" + String.valueOf((Object)INCLUDE) + "] or [" + String.valueOf((Object)EXCLUDE) + "] but was [" + modeString + "].");
        }
    }
}

