/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.protobufs;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensearch.protobufs.BulkRequestBody;
import org.opensearch.protobufs.BulkRequestBodyOrBuilder;
import org.opensearch.protobufs.BulkRequestOrBuilder;
import org.opensearch.protobufs.DocumentProto;
import org.opensearch.protobufs.Refresh;
import org.opensearch.protobufs.SourceConfigParam;
import org.opensearch.protobufs.SourceConfigParamOrBuilder;
import org.opensearch.protobufs.SourceType;
import org.opensearch.protobufs.WaitForActiveShards;
import org.opensearch.protobufs.WaitForActiveShardsOrBuilder;

public final class BulkRequest
extends GeneratedMessageV3
implements BulkRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int INDEX_FIELD_NUMBER = 1;
    private volatile Object index_ = "";
    public static final int SOURCE_FIELD_NUMBER = 2;
    private SourceConfigParam source_;
    public static final int SOURCE_EXCLUDES_FIELD_NUMBER = 3;
    private LazyStringArrayList sourceExcludes_ = LazyStringArrayList.emptyList();
    public static final int SOURCE_INCLUDES_FIELD_NUMBER = 4;
    private LazyStringArrayList sourceIncludes_ = LazyStringArrayList.emptyList();
    public static final int PIPELINE_FIELD_NUMBER = 5;
    private volatile Object pipeline_ = "";
    public static final int REFRESH_FIELD_NUMBER = 6;
    private int refresh_ = 0;
    public static final int REQUIRE_ALIAS_FIELD_NUMBER = 7;
    private boolean requireAlias_ = false;
    public static final int ROUTING_FIELD_NUMBER = 8;
    private volatile Object routing_ = "";
    public static final int TIMEOUT_FIELD_NUMBER = 9;
    private volatile Object timeout_ = "";
    public static final int TYPE_FIELD_NUMBER = 10;
    private volatile Object type_ = "";
    public static final int WAIT_FOR_ACTIVE_SHARDS_FIELD_NUMBER = 11;
    private WaitForActiveShards waitForActiveShards_;
    public static final int REQUEST_BODY_FIELD_NUMBER = 12;
    private List<BulkRequestBody> requestBody_;
    public static final int SOURCE_TYPE_FIELD_NUMBER = 13;
    private int sourceType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final BulkRequest DEFAULT_INSTANCE = new BulkRequest();
    private static final Parser<BulkRequest> PARSER = new AbstractParser<BulkRequest>(){

        public BulkRequest parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            Builder builder = BulkRequest.newBuilder();
            try {
                builder.mergeFrom(codedInputStream, extensionRegistryLite);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException uninitializedMessageException) {
                throw uninitializedMessageException.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException iOException) {
                throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private BulkRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private BulkRequest() {
        this.index_ = "";
        this.sourceExcludes_ = LazyStringArrayList.emptyList();
        this.sourceIncludes_ = LazyStringArrayList.emptyList();
        this.pipeline_ = "";
        this.refresh_ = 0;
        this.routing_ = "";
        this.timeout_ = "";
        this.type_ = "";
        this.requestBody_ = Collections.emptyList();
        this.sourceType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
        return new BulkRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DocumentProto.internal_static_BulkRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return DocumentProto.internal_static_BulkRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(BulkRequest.class, Builder.class);
    }

    @Override
    public boolean hasIndex() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getIndex() {
        Object object = this.index_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.index_ = string;
        return string;
    }

    @Override
    public ByteString getIndexBytes() {
        Object object = this.index_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.index_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasSource() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public SourceConfigParam getSource() {
        return this.source_ == null ? SourceConfigParam.getDefaultInstance() : this.source_;
    }

    @Override
    public SourceConfigParamOrBuilder getSourceOrBuilder() {
        return this.source_ == null ? SourceConfigParam.getDefaultInstance() : this.source_;
    }

    public ProtocolStringList getSourceExcludesList() {
        return this.sourceExcludes_;
    }

    @Override
    public int getSourceExcludesCount() {
        return this.sourceExcludes_.size();
    }

    @Override
    public String getSourceExcludes(int n) {
        return this.sourceExcludes_.get(n);
    }

    @Override
    public ByteString getSourceExcludesBytes(int n) {
        return this.sourceExcludes_.getByteString(n);
    }

    public ProtocolStringList getSourceIncludesList() {
        return this.sourceIncludes_;
    }

    @Override
    public int getSourceIncludesCount() {
        return this.sourceIncludes_.size();
    }

    @Override
    public String getSourceIncludes(int n) {
        return this.sourceIncludes_.get(n);
    }

    @Override
    public ByteString getSourceIncludesBytes(int n) {
        return this.sourceIncludes_.getByteString(n);
    }

    @Override
    public boolean hasPipeline() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getPipeline() {
        Object object = this.pipeline_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.pipeline_ = string;
        return string;
    }

    @Override
    public ByteString getPipelineBytes() {
        Object object = this.pipeline_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.pipeline_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasRefresh() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public int getRefreshValue() {
        return this.refresh_;
    }

    @Override
    public Refresh getRefresh() {
        Refresh refresh = Refresh.forNumber(this.refresh_);
        return refresh == null ? Refresh.UNRECOGNIZED : refresh;
    }

    @Override
    public boolean hasRequireAlias() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public boolean getRequireAlias() {
        return this.requireAlias_;
    }

    @Override
    public boolean hasRouting() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public String getRouting() {
        Object object = this.routing_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.routing_ = string;
        return string;
    }

    @Override
    public ByteString getRoutingBytes() {
        Object object = this.routing_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.routing_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasTimeout() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public String getTimeout() {
        Object object = this.timeout_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.timeout_ = string;
        return string;
    }

    @Override
    public ByteString getTimeoutBytes() {
        Object object = this.timeout_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.timeout_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasType() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public String getType() {
        Object object = this.type_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.type_ = string;
        return string;
    }

    @Override
    public ByteString getTypeBytes() {
        Object object = this.type_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.type_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasWaitForActiveShards() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public WaitForActiveShards getWaitForActiveShards() {
        return this.waitForActiveShards_ == null ? WaitForActiveShards.getDefaultInstance() : this.waitForActiveShards_;
    }

    @Override
    public WaitForActiveShardsOrBuilder getWaitForActiveShardsOrBuilder() {
        return this.waitForActiveShards_ == null ? WaitForActiveShards.getDefaultInstance() : this.waitForActiveShards_;
    }

    @Override
    public List<BulkRequestBody> getRequestBodyList() {
        return this.requestBody_;
    }

    @Override
    public List<? extends BulkRequestBodyOrBuilder> getRequestBodyOrBuilderList() {
        return this.requestBody_;
    }

    @Override
    public int getRequestBodyCount() {
        return this.requestBody_.size();
    }

    @Override
    public BulkRequestBody getRequestBody(int n) {
        return this.requestBody_.get(n);
    }

    @Override
    public BulkRequestBodyOrBuilder getRequestBodyOrBuilder(int n) {
        return this.requestBody_.get(n);
    }

    @Override
    public boolean hasSourceType() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public int getSourceTypeValue() {
        return this.sourceType_;
    }

    @Override
    public SourceType getSourceType() {
        SourceType sourceType = SourceType.forNumber(this.sourceType_);
        return sourceType == null ? SourceType.UNRECOGNIZED : sourceType;
    }

    public final boolean isInitialized() {
        byte by = this.memoizedIsInitialized;
        if (by == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        int n;
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)1, (Object)this.index_);
        }
        if ((this.bitField0_ & 2) != 0) {
            codedOutputStream.writeMessage(2, (MessageLite)this.getSource());
        }
        for (n = 0; n < this.sourceExcludes_.size(); ++n) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)3, (Object)this.sourceExcludes_.getRaw(n));
        }
        for (n = 0; n < this.sourceIncludes_.size(); ++n) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)4, (Object)this.sourceIncludes_.getRaw(n));
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)5, (Object)this.pipeline_);
        }
        if ((this.bitField0_ & 8) != 0) {
            codedOutputStream.writeEnum(6, this.refresh_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            codedOutputStream.writeBool(7, this.requireAlias_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)8, (Object)this.routing_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)9, (Object)this.timeout_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)10, (Object)this.type_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            codedOutputStream.writeMessage(11, (MessageLite)this.getWaitForActiveShards());
        }
        for (n = 0; n < this.requestBody_.size(); ++n) {
            codedOutputStream.writeMessage(12, (MessageLite)this.requestBody_.get(n));
        }
        if ((this.bitField0_ & 0x200) != 0) {
            codedOutputStream.writeEnum(13, this.sourceType_);
        }
        this.getUnknownFields().writeTo(codedOutputStream);
    }

    public int getSerializedSize() {
        int n;
        int n2 = this.memoizedSize;
        if (n2 != -1) {
            return n2;
        }
        n2 = 0;
        if ((this.bitField0_ & 1) != 0) {
            n2 += GeneratedMessageV3.computeStringSize((int)1, (Object)this.index_);
        }
        if ((this.bitField0_ & 2) != 0) {
            n2 += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getSource());
        }
        int n3 = 0;
        for (n = 0; n < this.sourceExcludes_.size(); ++n) {
            n3 += BulkRequest.computeStringSizeNoTag((Object)this.sourceExcludes_.getRaw(n));
        }
        n2 += n3;
        n2 += 1 * this.getSourceExcludesList().size();
        n3 = 0;
        for (n = 0; n < this.sourceIncludes_.size(); ++n) {
            n3 += BulkRequest.computeStringSizeNoTag((Object)this.sourceIncludes_.getRaw(n));
        }
        n2 += n3;
        n2 += 1 * this.getSourceIncludesList().size();
        if ((this.bitField0_ & 4) != 0) {
            n2 += GeneratedMessageV3.computeStringSize((int)5, (Object)this.pipeline_);
        }
        if ((this.bitField0_ & 8) != 0) {
            n2 += CodedOutputStream.computeEnumSize((int)6, (int)this.refresh_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            n2 += CodedOutputStream.computeBoolSize((int)7, (boolean)this.requireAlias_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            n2 += GeneratedMessageV3.computeStringSize((int)8, (Object)this.routing_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            n2 += GeneratedMessageV3.computeStringSize((int)9, (Object)this.timeout_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            n2 += GeneratedMessageV3.computeStringSize((int)10, (Object)this.type_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            n2 += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getWaitForActiveShards());
        }
        for (n3 = 0; n3 < this.requestBody_.size(); ++n3) {
            n2 += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.requestBody_.get(n3)));
        }
        if ((this.bitField0_ & 0x200) != 0) {
            n2 += CodedOutputStream.computeEnumSize((int)13, (int)this.sourceType_);
        }
        this.memoizedSize = n2 += this.getUnknownFields().getSerializedSize();
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BulkRequest)) {
            return super.equals(object);
        }
        BulkRequest bulkRequest = (BulkRequest)object;
        if (this.hasIndex() != bulkRequest.hasIndex()) {
            return false;
        }
        if (this.hasIndex() && !this.getIndex().equals(bulkRequest.getIndex())) {
            return false;
        }
        if (this.hasSource() != bulkRequest.hasSource()) {
            return false;
        }
        if (this.hasSource() && !this.getSource().equals(bulkRequest.getSource())) {
            return false;
        }
        if (!this.getSourceExcludesList().equals((Object)bulkRequest.getSourceExcludesList())) {
            return false;
        }
        if (!this.getSourceIncludesList().equals((Object)bulkRequest.getSourceIncludesList())) {
            return false;
        }
        if (this.hasPipeline() != bulkRequest.hasPipeline()) {
            return false;
        }
        if (this.hasPipeline() && !this.getPipeline().equals(bulkRequest.getPipeline())) {
            return false;
        }
        if (this.hasRefresh() != bulkRequest.hasRefresh()) {
            return false;
        }
        if (this.hasRefresh() && this.refresh_ != bulkRequest.refresh_) {
            return false;
        }
        if (this.hasRequireAlias() != bulkRequest.hasRequireAlias()) {
            return false;
        }
        if (this.hasRequireAlias() && this.getRequireAlias() != bulkRequest.getRequireAlias()) {
            return false;
        }
        if (this.hasRouting() != bulkRequest.hasRouting()) {
            return false;
        }
        if (this.hasRouting() && !this.getRouting().equals(bulkRequest.getRouting())) {
            return false;
        }
        if (this.hasTimeout() != bulkRequest.hasTimeout()) {
            return false;
        }
        if (this.hasTimeout() && !this.getTimeout().equals(bulkRequest.getTimeout())) {
            return false;
        }
        if (this.hasType() != bulkRequest.hasType()) {
            return false;
        }
        if (this.hasType() && !this.getType().equals(bulkRequest.getType())) {
            return false;
        }
        if (this.hasWaitForActiveShards() != bulkRequest.hasWaitForActiveShards()) {
            return false;
        }
        if (this.hasWaitForActiveShards() && !this.getWaitForActiveShards().equals(bulkRequest.getWaitForActiveShards())) {
            return false;
        }
        if (!this.getRequestBodyList().equals(bulkRequest.getRequestBodyList())) {
            return false;
        }
        if (this.hasSourceType() != bulkRequest.hasSourceType()) {
            return false;
        }
        if (this.hasSourceType() && this.sourceType_ != bulkRequest.sourceType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)bulkRequest.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int n = 41;
        n = 19 * n + BulkRequest.getDescriptor().hashCode();
        if (this.hasIndex()) {
            n = 37 * n + 1;
            n = 53 * n + this.getIndex().hashCode();
        }
        if (this.hasSource()) {
            n = 37 * n + 2;
            n = 53 * n + this.getSource().hashCode();
        }
        if (this.getSourceExcludesCount() > 0) {
            n = 37 * n + 3;
            n = 53 * n + this.getSourceExcludesList().hashCode();
        }
        if (this.getSourceIncludesCount() > 0) {
            n = 37 * n + 4;
            n = 53 * n + this.getSourceIncludesList().hashCode();
        }
        if (this.hasPipeline()) {
            n = 37 * n + 5;
            n = 53 * n + this.getPipeline().hashCode();
        }
        if (this.hasRefresh()) {
            n = 37 * n + 6;
            n = 53 * n + this.refresh_;
        }
        if (this.hasRequireAlias()) {
            n = 37 * n + 7;
            n = 53 * n + Internal.hashBoolean((boolean)this.getRequireAlias());
        }
        if (this.hasRouting()) {
            n = 37 * n + 8;
            n = 53 * n + this.getRouting().hashCode();
        }
        if (this.hasTimeout()) {
            n = 37 * n + 9;
            n = 53 * n + this.getTimeout().hashCode();
        }
        if (this.hasType()) {
            n = 37 * n + 10;
            n = 53 * n + this.getType().hashCode();
        }
        if (this.hasWaitForActiveShards()) {
            n = 37 * n + 11;
            n = 53 * n + this.getWaitForActiveShards().hashCode();
        }
        if (this.getRequestBodyCount() > 0) {
            n = 37 * n + 12;
            n = 53 * n + this.getRequestBodyList().hashCode();
        }
        if (this.hasSourceType()) {
            n = 37 * n + 13;
            n = 53 * n + this.sourceType_;
        }
        this.memoizedHashCode = n = 29 * n + this.getUnknownFields().hashCode();
        return n;
    }

    public static BulkRequest parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byteBuffer);
    }

    public static BulkRequest parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byteBuffer, extensionRegistryLite);
    }

    public static BulkRequest parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byteString);
    }

    public static BulkRequest parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byteString, extensionRegistryLite);
    }

    public static BulkRequest parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byArray);
    }

    public static BulkRequest parseFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (BulkRequest)PARSER.parseFrom(byArray, extensionRegistryLite);
    }

    public static BulkRequest parseFrom(InputStream inputStream) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream);
    }

    public static BulkRequest parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static BulkRequest parseDelimitedFrom(InputStream inputStream) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream);
    }

    public static BulkRequest parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static BulkRequest parseFrom(CodedInputStream codedInputStream) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream);
    }

    public static BulkRequest parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (BulkRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public Builder newBuilderForType() {
        return BulkRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BulkRequest bulkRequest) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(bulkRequest);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
        Builder builder = new Builder(builderParent);
        return builder;
    }

    public static BulkRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<BulkRequest> parser() {
        return PARSER;
    }

    public Parser<BulkRequest> getParserForType() {
        return PARSER;
    }

    public BulkRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements BulkRequestOrBuilder {
        private int bitField0_;
        private Object index_ = "";
        private SourceConfigParam source_;
        private SingleFieldBuilderV3<SourceConfigParam, SourceConfigParam.Builder, SourceConfigParamOrBuilder> sourceBuilder_;
        private LazyStringArrayList sourceExcludes_ = LazyStringArrayList.emptyList();
        private LazyStringArrayList sourceIncludes_ = LazyStringArrayList.emptyList();
        private Object pipeline_ = "";
        private int refresh_ = 0;
        private boolean requireAlias_;
        private Object routing_ = "";
        private Object timeout_ = "";
        private Object type_ = "";
        private WaitForActiveShards waitForActiveShards_;
        private SingleFieldBuilderV3<WaitForActiveShards, WaitForActiveShards.Builder, WaitForActiveShardsOrBuilder> waitForActiveShardsBuilder_;
        private List<BulkRequestBody> requestBody_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<BulkRequestBody, BulkRequestBody.Builder, BulkRequestBodyOrBuilder> requestBodyBuilder_;
        private int sourceType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return DocumentProto.internal_static_BulkRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return DocumentProto.internal_static_BulkRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(BulkRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent builderParent) {
            super(builderParent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getSourceFieldBuilder();
                this.getWaitForActiveShardsFieldBuilder();
                this.getRequestBodyFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.index_ = "";
            this.source_ = null;
            if (this.sourceBuilder_ != null) {
                this.sourceBuilder_.dispose();
                this.sourceBuilder_ = null;
            }
            this.sourceExcludes_ = LazyStringArrayList.emptyList();
            this.sourceIncludes_ = LazyStringArrayList.emptyList();
            this.pipeline_ = "";
            this.refresh_ = 0;
            this.requireAlias_ = false;
            this.routing_ = "";
            this.timeout_ = "";
            this.type_ = "";
            this.waitForActiveShards_ = null;
            if (this.waitForActiveShardsBuilder_ != null) {
                this.waitForActiveShardsBuilder_.dispose();
                this.waitForActiveShardsBuilder_ = null;
            }
            if (this.requestBodyBuilder_ == null) {
                this.requestBody_ = Collections.emptyList();
            } else {
                this.requestBody_ = null;
                this.requestBodyBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            this.sourceType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return DocumentProto.internal_static_BulkRequest_descriptor;
        }

        public BulkRequest getDefaultInstanceForType() {
            return BulkRequest.getDefaultInstance();
        }

        public BulkRequest build() {
            BulkRequest bulkRequest = this.buildPartial();
            if (!bulkRequest.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)bulkRequest);
            }
            return bulkRequest;
        }

        public BulkRequest buildPartial() {
            BulkRequest bulkRequest = new BulkRequest(this);
            this.buildPartialRepeatedFields(bulkRequest);
            if (this.bitField0_ != 0) {
                this.buildPartial0(bulkRequest);
            }
            this.onBuilt();
            return bulkRequest;
        }

        private void buildPartialRepeatedFields(BulkRequest bulkRequest) {
            if (this.requestBodyBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.requestBody_ = Collections.unmodifiableList(this.requestBody_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                bulkRequest.requestBody_ = this.requestBody_;
            } else {
                bulkRequest.requestBody_ = this.requestBodyBuilder_.build();
            }
        }

        private void buildPartial0(BulkRequest bulkRequest) {
            int n = this.bitField0_;
            int n2 = 0;
            if ((n & 1) != 0) {
                bulkRequest.index_ = this.index_;
                n2 |= 1;
            }
            if ((n & 2) != 0) {
                bulkRequest.source_ = this.sourceBuilder_ == null ? this.source_ : (SourceConfigParam)this.sourceBuilder_.build();
                n2 |= 2;
            }
            if ((n & 4) != 0) {
                this.sourceExcludes_.makeImmutable();
                bulkRequest.sourceExcludes_ = this.sourceExcludes_;
            }
            if ((n & 8) != 0) {
                this.sourceIncludes_.makeImmutable();
                bulkRequest.sourceIncludes_ = this.sourceIncludes_;
            }
            if ((n & 0x10) != 0) {
                bulkRequest.pipeline_ = this.pipeline_;
                n2 |= 4;
            }
            if ((n & 0x20) != 0) {
                bulkRequest.refresh_ = this.refresh_;
                n2 |= 8;
            }
            if ((n & 0x40) != 0) {
                bulkRequest.requireAlias_ = this.requireAlias_;
                n2 |= 0x10;
            }
            if ((n & 0x80) != 0) {
                bulkRequest.routing_ = this.routing_;
                n2 |= 0x20;
            }
            if ((n & 0x100) != 0) {
                bulkRequest.timeout_ = this.timeout_;
                n2 |= 0x40;
            }
            if ((n & 0x200) != 0) {
                bulkRequest.type_ = this.type_;
                n2 |= 0x80;
            }
            if ((n & 0x400) != 0) {
                bulkRequest.waitForActiveShards_ = this.waitForActiveShardsBuilder_ == null ? this.waitForActiveShards_ : (WaitForActiveShards)this.waitForActiveShardsBuilder_.build();
                n2 |= 0x100;
            }
            if ((n & 0x1000) != 0) {
                bulkRequest.sourceType_ = this.sourceType_;
                n2 |= 0x200;
            }
            bulkRequest.bitField0_ |= n2;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.setField(fieldDescriptor, object);
        }

        public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            return (Builder)super.clearField(fieldDescriptor);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            return (Builder)super.clearOneof(oneofDescriptor);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n, Object object) {
            return (Builder)super.setRepeatedField(fieldDescriptor, n, object);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.addRepeatedField(fieldDescriptor, object);
        }

        public Builder mergeFrom(Message message) {
            if (message instanceof BulkRequest) {
                return this.mergeFrom((BulkRequest)message);
            }
            super.mergeFrom(message);
            return this;
        }

        public Builder mergeFrom(BulkRequest bulkRequest) {
            if (bulkRequest == BulkRequest.getDefaultInstance()) {
                return this;
            }
            if (bulkRequest.hasIndex()) {
                this.index_ = bulkRequest.index_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (bulkRequest.hasSource()) {
                this.mergeSource(bulkRequest.getSource());
            }
            if (!bulkRequest.sourceExcludes_.isEmpty()) {
                if (this.sourceExcludes_.isEmpty()) {
                    this.sourceExcludes_ = bulkRequest.sourceExcludes_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureSourceExcludesIsMutable();
                    this.sourceExcludes_.addAll((Collection)bulkRequest.sourceExcludes_);
                }
                this.onChanged();
            }
            if (!bulkRequest.sourceIncludes_.isEmpty()) {
                if (this.sourceIncludes_.isEmpty()) {
                    this.sourceIncludes_ = bulkRequest.sourceIncludes_;
                    this.bitField0_ |= 8;
                } else {
                    this.ensureSourceIncludesIsMutable();
                    this.sourceIncludes_.addAll((Collection)bulkRequest.sourceIncludes_);
                }
                this.onChanged();
            }
            if (bulkRequest.hasPipeline()) {
                this.pipeline_ = bulkRequest.pipeline_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (bulkRequest.hasRefresh()) {
                this.setRefresh(bulkRequest.getRefresh());
            }
            if (bulkRequest.hasRequireAlias()) {
                this.setRequireAlias(bulkRequest.getRequireAlias());
            }
            if (bulkRequest.hasRouting()) {
                this.routing_ = bulkRequest.routing_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (bulkRequest.hasTimeout()) {
                this.timeout_ = bulkRequest.timeout_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (bulkRequest.hasType()) {
                this.type_ = bulkRequest.type_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (bulkRequest.hasWaitForActiveShards()) {
                this.mergeWaitForActiveShards(bulkRequest.getWaitForActiveShards());
            }
            if (this.requestBodyBuilder_ == null) {
                if (!bulkRequest.requestBody_.isEmpty()) {
                    if (this.requestBody_.isEmpty()) {
                        this.requestBody_ = bulkRequest.requestBody_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureRequestBodyIsMutable();
                        this.requestBody_.addAll(bulkRequest.requestBody_);
                    }
                    this.onChanged();
                }
            } else if (!bulkRequest.requestBody_.isEmpty()) {
                if (this.requestBodyBuilder_.isEmpty()) {
                    this.requestBodyBuilder_.dispose();
                    this.requestBodyBuilder_ = null;
                    this.requestBody_ = bulkRequest.requestBody_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.requestBodyBuilder_ = alwaysUseFieldBuilders ? this.getRequestBodyFieldBuilder() : null;
                } else {
                    this.requestBodyBuilder_.addAllMessages(bulkRequest.requestBody_);
                }
            }
            if (bulkRequest.hasSourceType()) {
                this.setSourceType(bulkRequest.getSourceType());
            }
            this.mergeUnknownFields(bulkRequest.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            if (extensionRegistryLite == null) {
                throw new NullPointerException();
            }
            try {
                boolean bl = false;
                block21: while (!bl) {
                    int n = codedInputStream.readTag();
                    switch (n) {
                        case 0: {
                            bl = true;
                            continue block21;
                        }
                        case 10: {
                            this.index_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getSourceFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 26: {
                            Object object = codedInputStream.readStringRequireUtf8();
                            this.ensureSourceExcludesIsMutable();
                            this.sourceExcludes_.add(object);
                            continue block21;
                        }
                        case 34: {
                            Object object = codedInputStream.readStringRequireUtf8();
                            this.ensureSourceIncludesIsMutable();
                            this.sourceIncludes_.add(object);
                            continue block21;
                        }
                        case 42: {
                            this.pipeline_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block21;
                        }
                        case 48: {
                            this.refresh_ = codedInputStream.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 56: {
                            this.requireAlias_ = codedInputStream.readBool();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 66: {
                            this.routing_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block21;
                        }
                        case 74: {
                            this.timeout_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block21;
                        }
                        case 82: {
                            this.type_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block21;
                        }
                        case 90: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getWaitForActiveShardsFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x400;
                            continue block21;
                        }
                        case 98: {
                            Object object = (BulkRequestBody)codedInputStream.readMessage(BulkRequestBody.parser(), extensionRegistryLite);
                            if (this.requestBodyBuilder_ == null) {
                                this.ensureRequestBodyIsMutable();
                                this.requestBody_.add((BulkRequestBody)object);
                                continue block21;
                            }
                            this.requestBodyBuilder_.addMessage((AbstractMessage)object);
                            continue block21;
                        }
                        case 104: {
                            this.sourceType_ = codedInputStream.readEnum();
                            this.bitField0_ |= 0x1000;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(codedInputStream, extensionRegistryLite, n)) continue;
                    bl = true;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasIndex() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getIndex() {
            Object object = this.index_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.index_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getIndexBytes() {
            Object object = this.index_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.index_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setIndex(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.index_ = string;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearIndex() {
            this.index_ = BulkRequest.getDefaultInstance().getIndex();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setIndexBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.index_ = byteString;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSource() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public SourceConfigParam getSource() {
            if (this.sourceBuilder_ == null) {
                return this.source_ == null ? SourceConfigParam.getDefaultInstance() : this.source_;
            }
            return (SourceConfigParam)this.sourceBuilder_.getMessage();
        }

        public Builder setSource(SourceConfigParam sourceConfigParam) {
            if (this.sourceBuilder_ == null) {
                if (sourceConfigParam == null) {
                    throw new NullPointerException();
                }
                this.source_ = sourceConfigParam;
            } else {
                this.sourceBuilder_.setMessage((AbstractMessage)sourceConfigParam);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setSource(SourceConfigParam.Builder builder) {
            if (this.sourceBuilder_ == null) {
                this.source_ = builder.build();
            } else {
                this.sourceBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeSource(SourceConfigParam sourceConfigParam) {
            if (this.sourceBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.source_ != null && this.source_ != SourceConfigParam.getDefaultInstance()) {
                    this.getSourceBuilder().mergeFrom(sourceConfigParam);
                } else {
                    this.source_ = sourceConfigParam;
                }
            } else {
                this.sourceBuilder_.mergeFrom((AbstractMessage)sourceConfigParam);
            }
            if (this.source_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSource() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.source_ = null;
            if (this.sourceBuilder_ != null) {
                this.sourceBuilder_.dispose();
                this.sourceBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SourceConfigParam.Builder getSourceBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (SourceConfigParam.Builder)this.getSourceFieldBuilder().getBuilder();
        }

        @Override
        public SourceConfigParamOrBuilder getSourceOrBuilder() {
            if (this.sourceBuilder_ != null) {
                return (SourceConfigParamOrBuilder)this.sourceBuilder_.getMessageOrBuilder();
            }
            return this.source_ == null ? SourceConfigParam.getDefaultInstance() : this.source_;
        }

        private SingleFieldBuilderV3<SourceConfigParam, SourceConfigParam.Builder, SourceConfigParamOrBuilder> getSourceFieldBuilder() {
            if (this.sourceBuilder_ == null) {
                this.sourceBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSource(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.source_ = null;
            }
            return this.sourceBuilder_;
        }

        private void ensureSourceExcludesIsMutable() {
            if (!this.sourceExcludes_.isModifiable()) {
                this.sourceExcludes_ = new LazyStringArrayList((LazyStringList)this.sourceExcludes_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getSourceExcludesList() {
            this.sourceExcludes_.makeImmutable();
            return this.sourceExcludes_;
        }

        @Override
        public int getSourceExcludesCount() {
            return this.sourceExcludes_.size();
        }

        @Override
        public String getSourceExcludes(int n) {
            return this.sourceExcludes_.get(n);
        }

        @Override
        public ByteString getSourceExcludesBytes(int n) {
            return this.sourceExcludes_.getByteString(n);
        }

        public Builder setSourceExcludes(int n, String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.ensureSourceExcludesIsMutable();
            this.sourceExcludes_.set(n, string);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addSourceExcludes(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.ensureSourceExcludesIsMutable();
            this.sourceExcludes_.add((Object)string);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllSourceExcludes(Iterable<String> iterable) {
            this.ensureSourceExcludesIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.sourceExcludes_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearSourceExcludes() {
            this.sourceExcludes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addSourceExcludesBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.ensureSourceExcludesIsMutable();
            this.sourceExcludes_.add(byteString);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensureSourceIncludesIsMutable() {
            if (!this.sourceIncludes_.isModifiable()) {
                this.sourceIncludes_ = new LazyStringArrayList((LazyStringList)this.sourceIncludes_);
            }
            this.bitField0_ |= 8;
        }

        public ProtocolStringList getSourceIncludesList() {
            this.sourceIncludes_.makeImmutable();
            return this.sourceIncludes_;
        }

        @Override
        public int getSourceIncludesCount() {
            return this.sourceIncludes_.size();
        }

        @Override
        public String getSourceIncludes(int n) {
            return this.sourceIncludes_.get(n);
        }

        @Override
        public ByteString getSourceIncludesBytes(int n) {
            return this.sourceIncludes_.getByteString(n);
        }

        public Builder setSourceIncludes(int n, String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.ensureSourceIncludesIsMutable();
            this.sourceIncludes_.set(n, string);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addSourceIncludes(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.ensureSourceIncludesIsMutable();
            this.sourceIncludes_.add((Object)string);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder addAllSourceIncludes(Iterable<String> iterable) {
            this.ensureSourceIncludesIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.sourceIncludes_);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearSourceIncludes() {
            this.sourceIncludes_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addSourceIncludesBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.ensureSourceIncludesIsMutable();
            this.sourceIncludes_.add(byteString);
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPipeline() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getPipeline() {
            Object object = this.pipeline_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.pipeline_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getPipelineBytes() {
            Object object = this.pipeline_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.pipeline_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setPipeline(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.pipeline_ = string;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPipeline() {
            this.pipeline_ = BulkRequest.getDefaultInstance().getPipeline();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setPipelineBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.pipeline_ = byteString;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRefresh() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public int getRefreshValue() {
            return this.refresh_;
        }

        public Builder setRefreshValue(int n) {
            this.refresh_ = n;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public Refresh getRefresh() {
            Refresh refresh = Refresh.forNumber(this.refresh_);
            return refresh == null ? Refresh.UNRECOGNIZED : refresh;
        }

        public Builder setRefresh(Refresh refresh) {
            if (refresh == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.refresh_ = refresh.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRefresh() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.refresh_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRequireAlias() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public boolean getRequireAlias() {
            return this.requireAlias_;
        }

        public Builder setRequireAlias(boolean bl) {
            this.requireAlias_ = bl;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearRequireAlias() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.requireAlias_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasRouting() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getRouting() {
            Object object = this.routing_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.routing_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getRoutingBytes() {
            Object object = this.routing_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.routing_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setRouting(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.routing_ = string;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearRouting() {
            this.routing_ = BulkRequest.getDefaultInstance().getRouting();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setRoutingBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.routing_ = byteString;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTimeout() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public String getTimeout() {
            Object object = this.timeout_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.timeout_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getTimeoutBytes() {
            Object object = this.timeout_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.timeout_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setTimeout(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.timeout_ = string;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearTimeout() {
            this.timeout_ = BulkRequest.getDefaultInstance().getTimeout();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setTimeoutBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.timeout_ = byteString;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasType() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public String getType() {
            Object object = this.type_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.type_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getTypeBytes() {
            Object object = this.type_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.type_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setType(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.type_ = string;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.type_ = BulkRequest.getDefaultInstance().getType();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setTypeBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            BulkRequest.checkByteStringIsUtf8((ByteString)byteString);
            this.type_ = byteString;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasWaitForActiveShards() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public WaitForActiveShards getWaitForActiveShards() {
            if (this.waitForActiveShardsBuilder_ == null) {
                return this.waitForActiveShards_ == null ? WaitForActiveShards.getDefaultInstance() : this.waitForActiveShards_;
            }
            return (WaitForActiveShards)this.waitForActiveShardsBuilder_.getMessage();
        }

        public Builder setWaitForActiveShards(WaitForActiveShards waitForActiveShards) {
            if (this.waitForActiveShardsBuilder_ == null) {
                if (waitForActiveShards == null) {
                    throw new NullPointerException();
                }
                this.waitForActiveShards_ = waitForActiveShards;
            } else {
                this.waitForActiveShardsBuilder_.setMessage((AbstractMessage)waitForActiveShards);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setWaitForActiveShards(WaitForActiveShards.Builder builder) {
            if (this.waitForActiveShardsBuilder_ == null) {
                this.waitForActiveShards_ = builder.build();
            } else {
                this.waitForActiveShardsBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeWaitForActiveShards(WaitForActiveShards waitForActiveShards) {
            if (this.waitForActiveShardsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.waitForActiveShards_ != null && this.waitForActiveShards_ != WaitForActiveShards.getDefaultInstance()) {
                    this.getWaitForActiveShardsBuilder().mergeFrom(waitForActiveShards);
                } else {
                    this.waitForActiveShards_ = waitForActiveShards;
                }
            } else {
                this.waitForActiveShardsBuilder_.mergeFrom((AbstractMessage)waitForActiveShards);
            }
            if (this.waitForActiveShards_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearWaitForActiveShards() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.waitForActiveShards_ = null;
            if (this.waitForActiveShardsBuilder_ != null) {
                this.waitForActiveShardsBuilder_.dispose();
                this.waitForActiveShardsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WaitForActiveShards.Builder getWaitForActiveShardsBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (WaitForActiveShards.Builder)this.getWaitForActiveShardsFieldBuilder().getBuilder();
        }

        @Override
        public WaitForActiveShardsOrBuilder getWaitForActiveShardsOrBuilder() {
            if (this.waitForActiveShardsBuilder_ != null) {
                return (WaitForActiveShardsOrBuilder)this.waitForActiveShardsBuilder_.getMessageOrBuilder();
            }
            return this.waitForActiveShards_ == null ? WaitForActiveShards.getDefaultInstance() : this.waitForActiveShards_;
        }

        private SingleFieldBuilderV3<WaitForActiveShards, WaitForActiveShards.Builder, WaitForActiveShardsOrBuilder> getWaitForActiveShardsFieldBuilder() {
            if (this.waitForActiveShardsBuilder_ == null) {
                this.waitForActiveShardsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getWaitForActiveShards(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.waitForActiveShards_ = null;
            }
            return this.waitForActiveShardsBuilder_;
        }

        private void ensureRequestBodyIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.requestBody_ = new ArrayList<BulkRequestBody>(this.requestBody_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<BulkRequestBody> getRequestBodyList() {
            if (this.requestBodyBuilder_ == null) {
                return Collections.unmodifiableList(this.requestBody_);
            }
            return this.requestBodyBuilder_.getMessageList();
        }

        @Override
        public int getRequestBodyCount() {
            if (this.requestBodyBuilder_ == null) {
                return this.requestBody_.size();
            }
            return this.requestBodyBuilder_.getCount();
        }

        @Override
        public BulkRequestBody getRequestBody(int n) {
            if (this.requestBodyBuilder_ == null) {
                return this.requestBody_.get(n);
            }
            return (BulkRequestBody)this.requestBodyBuilder_.getMessage(n);
        }

        public Builder setRequestBody(int n, BulkRequestBody bulkRequestBody) {
            if (this.requestBodyBuilder_ == null) {
                if (bulkRequestBody == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestBodyIsMutable();
                this.requestBody_.set(n, bulkRequestBody);
                this.onChanged();
            } else {
                this.requestBodyBuilder_.setMessage(n, (AbstractMessage)bulkRequestBody);
            }
            return this;
        }

        public Builder setRequestBody(int n, BulkRequestBody.Builder builder) {
            if (this.requestBodyBuilder_ == null) {
                this.ensureRequestBodyIsMutable();
                this.requestBody_.set(n, builder.build());
                this.onChanged();
            } else {
                this.requestBodyBuilder_.setMessage(n, (AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addRequestBody(BulkRequestBody bulkRequestBody) {
            if (this.requestBodyBuilder_ == null) {
                if (bulkRequestBody == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestBodyIsMutable();
                this.requestBody_.add(bulkRequestBody);
                this.onChanged();
            } else {
                this.requestBodyBuilder_.addMessage((AbstractMessage)bulkRequestBody);
            }
            return this;
        }

        public Builder addRequestBody(int n, BulkRequestBody bulkRequestBody) {
            if (this.requestBodyBuilder_ == null) {
                if (bulkRequestBody == null) {
                    throw new NullPointerException();
                }
                this.ensureRequestBodyIsMutable();
                this.requestBody_.add(n, bulkRequestBody);
                this.onChanged();
            } else {
                this.requestBodyBuilder_.addMessage(n, (AbstractMessage)bulkRequestBody);
            }
            return this;
        }

        public Builder addRequestBody(BulkRequestBody.Builder builder) {
            if (this.requestBodyBuilder_ == null) {
                this.ensureRequestBodyIsMutable();
                this.requestBody_.add(builder.build());
                this.onChanged();
            } else {
                this.requestBodyBuilder_.addMessage((AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addRequestBody(int n, BulkRequestBody.Builder builder) {
            if (this.requestBodyBuilder_ == null) {
                this.ensureRequestBodyIsMutable();
                this.requestBody_.add(n, builder.build());
                this.onChanged();
            } else {
                this.requestBodyBuilder_.addMessage(n, (AbstractMessage)builder.build());
            }
            return this;
        }

        public Builder addAllRequestBody(Iterable<? extends BulkRequestBody> iterable) {
            if (this.requestBodyBuilder_ == null) {
                this.ensureRequestBodyIsMutable();
                AbstractMessageLite.Builder.addAll(iterable, this.requestBody_);
                this.onChanged();
            } else {
                this.requestBodyBuilder_.addAllMessages(iterable);
            }
            return this;
        }

        public Builder clearRequestBody() {
            if (this.requestBodyBuilder_ == null) {
                this.requestBody_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.requestBodyBuilder_.clear();
            }
            return this;
        }

        public Builder removeRequestBody(int n) {
            if (this.requestBodyBuilder_ == null) {
                this.ensureRequestBodyIsMutable();
                this.requestBody_.remove(n);
                this.onChanged();
            } else {
                this.requestBodyBuilder_.remove(n);
            }
            return this;
        }

        public BulkRequestBody.Builder getRequestBodyBuilder(int n) {
            return (BulkRequestBody.Builder)this.getRequestBodyFieldBuilder().getBuilder(n);
        }

        @Override
        public BulkRequestBodyOrBuilder getRequestBodyOrBuilder(int n) {
            if (this.requestBodyBuilder_ == null) {
                return this.requestBody_.get(n);
            }
            return (BulkRequestBodyOrBuilder)this.requestBodyBuilder_.getMessageOrBuilder(n);
        }

        @Override
        public List<? extends BulkRequestBodyOrBuilder> getRequestBodyOrBuilderList() {
            if (this.requestBodyBuilder_ != null) {
                return this.requestBodyBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.requestBody_);
        }

        public BulkRequestBody.Builder addRequestBodyBuilder() {
            return (BulkRequestBody.Builder)this.getRequestBodyFieldBuilder().addBuilder((AbstractMessage)BulkRequestBody.getDefaultInstance());
        }

        public BulkRequestBody.Builder addRequestBodyBuilder(int n) {
            return (BulkRequestBody.Builder)this.getRequestBodyFieldBuilder().addBuilder(n, (AbstractMessage)BulkRequestBody.getDefaultInstance());
        }

        public List<BulkRequestBody.Builder> getRequestBodyBuilderList() {
            return this.getRequestBodyFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<BulkRequestBody, BulkRequestBody.Builder, BulkRequestBodyOrBuilder> getRequestBodyFieldBuilder() {
            if (this.requestBodyBuilder_ == null) {
                this.requestBodyBuilder_ = new RepeatedFieldBuilderV3(this.requestBody_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.requestBody_ = null;
            }
            return this.requestBodyBuilder_;
        }

        @Override
        public boolean hasSourceType() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public int getSourceTypeValue() {
            return this.sourceType_;
        }

        public Builder setSourceTypeValue(int n) {
            this.sourceType_ = n;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public SourceType getSourceType() {
            SourceType sourceType = SourceType.forNumber(this.sourceType_);
            return sourceType == null ? SourceType.UNRECOGNIZED : sourceType;
        }

        public Builder setSourceType(SourceType sourceType) {
            if (sourceType == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000;
            this.sourceType_ = sourceType.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSourceType() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.sourceType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.setUnknownFields(unknownFieldSet);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.mergeUnknownFields(unknownFieldSet);
        }
    }
}

