/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;

final class IntervalMatches {
    IntervalMatches() {
    }

    static IntervalMatchesIterator asMatches(final IntervalIterator iterator, final IntervalMatchesIterator source, int doc) throws IOException {
        if (source == null) {
            return null;
        }
        if (iterator.advance(doc) != doc) {
            return null;
        }
        if (iterator.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new IntervalMatchesIterator(){
            boolean cached = true;

            public boolean next() throws IOException {
                if (this.cached) {
                    this.cached = false;
                    return true;
                }
                return iterator.nextInterval() != Integer.MAX_VALUE;
            }

            public int startPosition() {
                return iterator.start();
            }

            public int endPosition() {
                return iterator.end();
            }

            public int startOffset() throws IOException {
                return source.startOffset();
            }

            public int endOffset() throws IOException {
                return source.endOffset();
            }

            @Override
            public int gaps() {
                return iterator.gaps();
            }

            @Override
            public int width() {
                return iterator.width();
            }

            public MatchesIterator getSubMatches() throws IOException {
                return source.getSubMatches();
            }

            public Query getQuery() {
                return source.getQuery();
            }
        };
    }

    static IntervalIterator wrapMatches(final IntervalMatchesIterator mi, final int doc) {
        return new IntervalIterator(){
            State state = State.UNPOSITIONED;

            @Override
            public int start() {
                if (this.state == State.NO_MORE_INTERVALS) {
                    return Integer.MAX_VALUE;
                }
                assert (this.state == State.ITERATING);
                return mi.startPosition();
            }

            @Override
            public int end() {
                if (this.state == State.NO_MORE_INTERVALS) {
                    return Integer.MAX_VALUE;
                }
                assert (this.state == State.ITERATING);
                return mi.endPosition();
            }

            @Override
            public int gaps() {
                assert (this.state == State.ITERATING);
                return mi.gaps();
            }

            @Override
            public int width() {
                assert (this.state == State.ITERATING);
                return mi.width();
            }

            @Override
            public int nextInterval() throws IOException {
                assert (this.state == State.ITERATING);
                if (mi.next()) {
                    return mi.startPosition();
                }
                this.state = State.NO_MORE_INTERVALS;
                return Integer.MAX_VALUE;
            }

            @Override
            public float matchCost() {
                return 1.0f;
            }

            public int docID() {
                switch (this.state.ordinal()) {
                    case 0: {
                        return -1;
                    }
                    case 1: 
                    case 2: {
                        return doc;
                    }
                }
                return Integer.MAX_VALUE;
            }

            public int nextDoc() {
                switch (this.state.ordinal()) {
                    case 0: {
                        this.state = State.ITERATING;
                        return doc;
                    }
                    case 1: 
                    case 2: {
                        this.state = State.EXHAUSTED;
                        break;
                    }
                }
                return Integer.MAX_VALUE;
            }

            public int advance(int target) {
                if (target == doc) {
                    this.state = State.ITERATING;
                    return doc;
                }
                this.state = State.EXHAUSTED;
                return Integer.MAX_VALUE;
            }

            public long cost() {
                return 1L;
            }
        };
    }

    static enum State {
        UNPOSITIONED,
        ITERATING,
        NO_MORE_INTERVALS,
        EXHAUSTED;

    }
}

