/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.BitsProducer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.CompletionScorer;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.search.suggest.document.NRTSuggester;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;

public class CompletionWeight
extends Weight {
    private final CompletionQuery completionQuery;
    private final Automaton automaton;

    public CompletionWeight(CompletionQuery query, Automaton automaton) throws IOException {
        super((Query)query);
        this.completionQuery = query;
        this.automaton = automaton;
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    protected void setNextMatch(IntsRef pathPrefix) {
    }

    protected float boost() {
        return 0.0f;
    }

    protected CharSequence context() {
        return null;
    }

    public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
        final CompletionWeight weight = this;
        return new ScorerSupplier(){

            public Scorer get(long leadCost) throws IOException {
                throw new UnsupportedOperationException();
            }

            public BulkScorer bulkScorer() throws IOException {
                NRTSuggester suggester;
                LeafReader reader = context.reader();
                Terms terms = reader.terms(CompletionWeight.this.completionQuery.getField());
                if (terms == null) {
                    return null;
                }
                if (terms instanceof CompletionTerms) {
                    CompletionTerms completionTerms = (CompletionTerms)terms;
                    suggester = completionTerms.suggester();
                    if (suggester == null) {
                        return null;
                    }
                } else {
                    throw new IllegalArgumentException(CompletionWeight.this.completionQuery.getField() + " is not a SuggestField");
                }
                BitsProducer filter = CompletionWeight.this.completionQuery.getFilter();
                Bits filteredDocs = null;
                if (filter != null && (filteredDocs = filter.getBits(context)).getClass() == Bits.MatchNoBits.class) {
                    return null;
                }
                return new CompletionScorer(weight, suggester, reader, filteredDocs, filter != null, CompletionWeight.this.automaton);
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return null;
    }
}

