function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { OuiPopover, OuiPopoverFooter } from '../popover';
import { keys } from '../../services';
import { OuiFlexGroup, OuiFlexItem } from '../flex';
import { OuiButtonEmpty } from '../button/button_empty';
export function OuiDataGridCellPopover(_ref) {
  var anchorContent = _ref.anchorContent,
    cellContentProps = _ref.cellContentProps,
    cellContentsRef = _ref.cellContentsRef,
    closePopover = _ref.closePopover,
    column = _ref.column,
    panelRefFn = _ref.panelRefFn,
    PopoverContent = _ref.popoverContent,
    popoverIsOpen = _ref.popoverIsOpen,
    renderCellValue = _ref.renderCellValue,
    rowIndex = _ref.rowIndex;
  var CellElement = renderCellValue;
  return /*#__PURE__*/React.createElement(OuiPopover, {
    hasArrow: false,
    anchorClassName: "ouiDataGridRowCell__expand",
    button: anchorContent,
    isOpen: popoverIsOpen,
    panelRef: panelRefFn,
    panelClassName: "ouiDataGridRowCell__popover",
    panelPaddingSize: "s",
    zIndex: 8001,
    display: "block",
    closePopover: closePopover,
    onKeyDown: function onKeyDown(event) {
      if (event.key === keys.F2 || event.key === keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        closePopover();
      }
    }
  }, popoverIsOpen ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(PopoverContent, {
    cellContentsElement: cellContentsRef
  }, /*#__PURE__*/React.createElement(CellElement, _extends({}, cellContentProps, {
    isDetails: true
  }))), column && column.cellActions && column.cellActions.length ? /*#__PURE__*/React.createElement(OuiPopoverFooter, null, /*#__PURE__*/React.createElement(OuiFlexGroup, {
    gutterSize: "s"
  }, column.cellActions.map(function (Action, idx) {
    var CellButtonElement = Action;
    return /*#__PURE__*/React.createElement(OuiFlexItem, {
      key: idx
    }, /*#__PURE__*/React.createElement(CellButtonElement, {
      rowIndex: rowIndex,
      columnId: column.id,
      Component: function Component(props) {
        return /*#__PURE__*/React.createElement(OuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true,
      closePopover: closePopover
    }));
  }))) : null) : null);
}

/* OUI -> EUI Aliases: Build-Time */
export { EuiDataGridCellPopover } from '../../eui_components/datagrid/data_grid_cell_popover';